/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MethodModifiersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MethodParametersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

final class MethodPropertiesPanel
extends AbstractPanel {
    private PropertyValueModel methodHolder;
    private PropertyValueModel returnTypeHolder;

    MethodPropertiesPanel(PropertyValueModel methodHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.methodHolder = methodHolder;
        this.returnTypeHolder = this.buildReturnTypeHolder();
        this.initializeLayout();
    }

    private PropertyValueModel buildReturnTypeHolder() {
        PropertyAspectAdapter adapter = new PropertyAspectAdapter(this.methodHolder, "returnType"){

            @Override
            protected Object getValueFromSubject() {
                if (((MWMethod)this.subject).isConstructor()) {
                    return null;
                }
                return ((MWMethod)this.subject).getReturnType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWMethod)this.subject).setReturnType((MWClass)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
    }

    protected String helpTopicId() {
        return "descriptor.classInfo.methods.properties";
    }

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        MethodModifiersPanel modifiersPanel = new MethodModifiersPanel((ValueModel)this.methodHolder, this.getApplicationContext());
        this.addHelpTopicId(modifiersPanel, this.helpTopicId() + ".modifiers");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)modifiersPanel, constraints);
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setBorder(this.buildTitledBorder("RETURN_TYPE_PANEL_TITLE"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)typePanel, constraints);
        JLabel returnTypeLabel = this.buildLabel("RETURN_TYPE_LABEL");
        returnTypeLabel.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(returnTypeLabel));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        typePanel.add((Component)returnTypeLabel, constraints);
        ClassChooserPanel returnTypeClassChooserPanel = ClassChooserTools.buildPanel(this.returnTypeHolder, this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableFilter(), returnTypeLabel, this.getWorkbenchContextHolder());
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(returnTypeClassChooserPanel));
        returnTypeClassChooserPanel.setEnabled(false);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        typePanel.add((Component)returnTypeClassChooserPanel, constraints);
        JLabel dimensionalityLabel = this.buildLabel("DIMENSIONALITY_LABEL");
        dimensionalityLabel.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(dimensionalityLabel));
        this.returnTypeHolder.addPropertyChangeListener("value", this.buildReturnTypeListener(dimensionalityLabel));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 0);
        typePanel.add((Component)dimensionalityLabel, constraints);
        JSpinner arraySizeSpinButton = this.buildDimensionalitySpinner();
        dimensionalityLabel.setLabelFor(arraySizeSpinButton);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 5, 5);
        typePanel.add((Component)arraySizeSpinButton, constraints);
        this.addHelpTopicId(typePanel, this.helpTopicId() + ".typeInfo");
        MethodParametersPanel parametersPanel = new MethodParametersPanel(this.methodHolder, this.getWorkbenchContextHolder());
        parametersPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PARAMETERS_TABLE_LABEL"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)parametersPanel, constraints);
        this.addHelpTopicId(parametersPanel, this.helpTopicId() + ".parameters");
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return MethodPropertiesPanel.this.getMethod().getRepository();
            }
        };
    }

    private JSpinner buildDimensionalitySpinner() {
        JSpinner spinner = new JSpinner(this.buildDimensionalitySpinnerModel());
        spinner.setPreferredSize(new Dimension(50, spinner.getPreferredSize().height));
        spinner.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(spinner));
        this.returnTypeHolder.addPropertyChangeListener("value", this.buildReturnTypeListener(spinner));
        return spinner;
    }

    private SpinnerModel buildDimensionalitySpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildDimensionalityHolder(), new Integer(0), null, new Integer(1), new Integer(0));
    }

    private PropertyValueModel buildDimensionalityHolder() {
        return new PropertyAspectAdapter(this.methodHolder, "returnTypeDimensionality"){

            @Override
            protected Object getValueFromSubject() {
                if (((MWMethod)this.subject).isConstructor()) {
                    return new Integer(0);
                }
                return new Integer(((MWMethod)this.subject).getReturnTypeDimensionality());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWMethod)this.subject).setReturnTypeDimensionality(((Integer)value).intValue());
            }
        };
    }

    private PropertyChangeListener buildMethodListener(final Component component) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(MethodPropertiesPanel.this.getMethod() != null && !MethodPropertiesPanel.this.getMethod().isConstructor());
            }
        };
    }

    private PropertyChangeListener buildReturnTypeListener(final Component component) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(evt.getNewValue() == null ? false : !((MWClass)evt.getNewValue()).isVoid());
            }
        };
    }

    private MWMethod getMethod() {
        return (MWMethod)this.methodHolder.getValue();
    }
}

