/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.events.ReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;

class SingleMethodReflectiveChangeListener
extends ReflectiveChangeListener
implements StateChangeListener,
PropertyChangeListener {
    private Method method;
    private boolean methodIsZeroArgument;

    SingleMethodReflectiveChangeListener(Object target, Method method) {
        super(target);
        this.method = method;
        this.methodIsZeroArgument = method.getParameterTypes().length == 0;
    }

    @Override
    public void stateChanged(StateChangeEvent e) {
        if (this.methodIsZeroArgument) {
            ClassTools.invokeMethod(this.method, this.target, EMPTY_STATE_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(this.method, this.target, new StateChangeEvent[]{e});
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.methodIsZeroArgument) {
            ClassTools.invokeMethod(this.method, this.target, EMPTY_PROPERTY_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(this.method, this.target, new PropertyChangeEvent[]{e});
        }
    }
}

