/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariableType;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LocalVariableTypeTableAttribute
extends Attribute {
    private short count;
    private LocalVariableType[] localVariableTypes;

    public LocalVariableTypeTableAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    @Override
    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        LocalVariableType[] types = this.localVariableTypes = new LocalVariableType[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            types[i] = new LocalVariableType(stream, this.constantPool());
        }
    }

    @Override
    public void displayNameOn(IndentingPrintWriter writer) {
        super.displayNameOn(writer);
        writer.print(" (count: ");
        writer.print(this.count);
        writer.print(")");
    }

    @Override
    void displayInfoStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        LocalVariableType[] types = this.localVariableTypes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            types[i].displayStringOn(writer);
        }
    }

    public String localVariableTypeName(short index) {
        return this.localVariableTypes[index].name();
    }

    public LocalVariableType localVariableTypeNamed(String name) {
        short cnt = this.count;
        LocalVariableType[] types = this.localVariableTypes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            LocalVariableType type = types[i];
            if (!type.isNamed(name)) continue;
            return type;
        }
        return null;
    }

    public String[] localVariableTypeNames() {
        short cnt = this.count;
        if (cnt == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] names = new String[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            names[i] = this.localVariableTypeName(i);
        }
        return names;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        LocalVariableType[] types = this.localVariableTypes;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            types[i].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public LocalVariableType[] getLocalVariableTypes() {
        return this.localVariableTypes;
    }

    public LocalVariableType getLocalVariableType(short index) {
        return this.localVariableTypes[index];
    }

    @Override
    void toString(StringBuffer sb) {
        sb.append(this.count);
        sb.append(" local variable type(s)");
    }
}

