/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class InvokeDynamicConstant
extends Constant {
    private short bootstrapMethodAttrIndex;
    private short nameAndTypeIndex;

    InvokeDynamicConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.bootstrapMethodAttrIndex = stream.readU2();
        this.nameAndTypeIndex = stream.readU2();
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" name: ");
        writer.print(this.name());
        writer.print("  descriptor: ");
        writer.println(this.descriptor());
    }

    @Override
    public String description() {
        return "invokeDynamic";
    }

    @Override
    public Object value() {
        return null;
    }

    public String name() {
        return this.nameAndTypeConstant().name();
    }

    public String descriptor() {
        return this.nameAndTypeConstant().descriptor();
    }

    public NameAndTypeConstant nameAndTypeConstant() {
        return this.getPool().getNameAndTypeConstant(this.nameAndTypeIndex);
    }

    public short getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

