/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.eis.mappings.EISOneToOneMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlFieldPair
extends MWModel
implements MWXmlNode,
MWXpathContext {
    private MWXmlField sourceXmlField;
    private MWXmlField targetXmlField;

    protected MWXmlFieldPair() {
    }

    MWXmlFieldPair(MWXmlReferenceMapping parent) {
        super(parent);
    }

    MWXmlFieldPair(MWXmlReferenceMapping parent, String sourceXpath, String targetXpath) {
        this(parent);
        this.sourceXmlField.setXpath(sourceXpath);
        this.targetXmlField.setXpath(targetXpath);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.sourceXmlField = new MWXmlField(this);
        this.targetXmlField = new MWXmlField(this);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.sourceXmlField);
        children.add(this.targetXmlField);
    }

    public MWXmlField getSourceXmlField() {
        return this.sourceXmlField;
    }

    public MWXmlField getTargetXmlField() {
        return this.targetXmlField;
    }

    @Override
    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        if (xmlField == this.getTargetXmlField()) {
            MWXmlDescriptor xmlReferenceDescriptor = this.xmlReferenceDescriptor();
            return xmlReferenceDescriptor == null ? null : xmlReferenceDescriptor.getSchemaContext();
        }
        return this.xmlDescriptor().getSchemaContext();
    }

    @Override
    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec(xmlField);
    }

    protected MWXpathSpec buildXpathSpec(final MWXmlField xmlField) {
        return new MWXpathSpec(){

            @Override
            public boolean mayUseCollectionData() {
                return MWXmlFieldPair.this.mayUseCollectionXpath(xmlField);
            }

            @Override
            public boolean mayUseComplexData() {
                return false;
            }

            @Override
            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    protected boolean mayUseCollectionXpath(MWXmlField xmlField) {
        if (xmlField == this.getSourceXmlField()) {
            return this.xmlRefMapping().sourceFieldMayUseCollectionXpath();
        }
        return false;
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.xmlRefMapping().getParent();
    }

    private MWXmlReferenceMapping xmlRefMapping() {
        return (MWXmlReferenceMapping)this.getParent();
    }

    private MWXmlDescriptor xmlReferenceDescriptor() {
        return this.xmlRefMapping().referenceDescriptor();
    }

    @Override
    public void resolveXpaths() {
        this.sourceXmlField.resolveXpaths();
        this.targetXmlField.resolveXpaths();
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        this.sourceXmlField.schemaChanged(change);
        this.targetXmlField.schemaChanged(change);
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addSourceFieldMissingProblemTo(currentProblems);
        this.addTargetFieldMissingProblemTo(currentProblems);
    }

    private void addSourceFieldMissingProblemTo(List newProblems) {
        if (!this.getSourceXmlField().isSpecified()) {
            newProblems.add(this.buildProblem("0594"));
        }
    }

    private void addTargetFieldMissingProblemTo(List newProblems) {
        if (!this.getTargetXmlField().isSpecified()) {
            newProblems.add(this.buildProblem("0595"));
        }
    }

    public boolean duplicateSourceXpath(String xpath) {
        if (xpath.equals("")) {
            return false;
        }
        ListIterator<MWXmlFieldPair> stream = this.xmlRefMapping().xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlFieldPair fieldPair = (MWXmlFieldPair)stream.next();
            if (fieldPair == this || !xpath.equals(fieldPair.getSourceXmlField().getXpath())) continue;
            return true;
        }
        return false;
    }

    public boolean duplicateTargetXpath(String xpath) {
        if (xpath.equals("")) {
            return false;
        }
        ListIterator<MWXmlFieldPair> stream = this.xmlRefMapping().xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlFieldPair fieldPair = (MWXmlFieldPair)stream.next();
            if (fieldPair == this || !xpath.equals(fieldPair.getTargetXmlField().getXpath())) continue;
            return true;
        }
        return false;
    }

    public void addRuntimeForeignKeyField(EISOneToOneMapping mapping) {
        if (this.getSourceXmlField().isSpecified() && this.getTargetXmlField().isSpecified()) {
            mapping.addForeignKeyField(this.getSourceXmlField().runtimeField(), this.getTargetXmlField().runtimeField());
        }
    }

    public void addRuntimeForeignKeyField(EISOneToManyMapping mapping, MWXmlField groupingElement) {
        if (this.getSourceXmlField().isSpecified() && this.getTargetXmlField().isSpecified()) {
            mapping.addForeignKeyField(this.getSourceXmlField().runtimeField(groupingElement), this.getTargetXmlField().runtimeField(groupingElement));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlFieldPair.class);
        XMLCompositeObjectMapping sourceFieldMapping = new XMLCompositeObjectMapping();
        sourceFieldMapping.setReferenceClass(MWXmlField.class);
        sourceFieldMapping.setAttributeName("sourceXmlField");
        sourceFieldMapping.setGetMethodName("getSourceXmlFieldForTopLink");
        sourceFieldMapping.setSetMethodName("setSourceXmlFieldForTopLink");
        sourceFieldMapping.setXPath("source-xml-field");
        descriptor.addMapping((DatabaseMapping)sourceFieldMapping);
        XMLCompositeObjectMapping targetFieldMapping = new XMLCompositeObjectMapping();
        targetFieldMapping.setReferenceClass(MWXmlField.class);
        targetFieldMapping.setAttributeName("targetXmlDataFieldHandle");
        targetFieldMapping.setGetMethodName("getTargetXmlFieldForTopLink");
        targetFieldMapping.setSetMethodName("setTargetXmlFieldForTopLink");
        targetFieldMapping.setXPath("target-xml-field");
        descriptor.addMapping((DatabaseMapping)targetFieldMapping);
        return descriptor;
    }

    private MWXmlField getSourceXmlFieldForTopLink() {
        return this.sourceXmlField.isSpecified() ? this.sourceXmlField : null;
    }

    private void setSourceXmlFieldForTopLink(MWXmlField xmlField) {
        this.sourceXmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }

    private MWXmlField getTargetXmlFieldForTopLink() {
        return this.targetXmlField.isSpecified() ? this.targetXmlField : null;
    }

    private void setTargetXmlFieldForTopLink(MWXmlField xmlField) {
        this.targetXmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

