/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;

public class CacheStatementBatchWritingTest
extends TransactionalTestCase {
    protected static int NUM_INSERTS = 102;
    protected boolean shouldCacheStatements;
    protected boolean shouldBindAllParams;

    public CacheStatementBatchWritingTest() {
        this.setDescription("Tests a large number of inserts using Batch Writing, verifies that statement cacheing is used");
    }

    public void setup() {
        super.setup();
        this.shouldCacheStatements = this.getSession().getPlatform().shouldCacheAllStatements();
        this.shouldBindAllParams = this.getSession().getPlatform().shouldBindAllParameters();
        this.getSession().getPlatform().setShouldCacheAllStatements(true);
        this.getSession().getPlatform().setShouldBindAllParameters(true);
        ((DatabaseAccessor)this.getAbstractSession().getAccessor()).clearStatementCache((AbstractSession)this.getSession());
    }

    public void reset() {
        super.reset();
        this.getSession().getPlatform().setShouldCacheAllStatements(this.shouldCacheStatements);
        this.getSession().getPlatform().setShouldBindAllParameters(this.shouldBindAllParams);
        ((DatabaseAccessor)this.getAbstractSession().getAccessor()).clearStatementCache((AbstractSession)this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Address address;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (int i = 0; i < NUM_INSERTS; ++i) {
            address = new Address();
            address.setCity("city" + i);
            address.setProvince("province" + i);
            uow.registerObject((Object)address);
        }
        uow.commit();
        ((DatabaseAccessor)uow.getParent().getAccessor()).getActiveBatchWritingMechanism(this.getAbstractSession()).executeBatchedStatements(uow.getParent());
        PreparedStatement statement = null;
        Map statementCache = null;
        String sql = this.getSession().getDescriptor(Address.class).getQueryManager().getInsertQuery().getSQLString();
        try {
            Method method = uow.getParent().getAccessor().getClass().getDeclaredMethod("getStatementCache", new Class[0]);
            method.setAccessible(true);
            statementCache = (Map)method.invoke((Object)((DatabaseAccessor)uow.getParent().getAccessor()), new Object[0]);
            statement = (PreparedStatement)statementCache.get(sql);
        }
        catch (Exception ex) {
            throw new TestErrorException("Failed to run test. Check java.policy file \"SupressAccessChecks\" perission required :" + ex.toString());
        }
        try {
            statement.close();
        }
        catch (SQLException ex) {
            throw new TestErrorException("Failed on modifying the statementCache");
        }
        uow = this.getSession().acquireUnitOfWork();
        for (int i = 0; i < NUM_INSERTS; ++i) {
            address = new Address();
            address.setCity("city" + (i + NUM_INSERTS));
            address.setProvince("province" + (i + NUM_INSERTS));
            uow.registerObject((Object)address);
        }
        try {
            uow.commit();
            ((DatabaseAccessor)uow.getParent().getAccessor()).getActiveBatchWritingMechanism(this.getAbstractSession()).executeBatchedStatements(uow.getParent());
        }
        catch (Exception ex) {
            return;
        }
        finally {
            statementCache.remove(sql);
        }
        throw new TestErrorException("Statements were not cached correctly");
    }
}

