/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.jpa.IsolatedHashMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.testing.framework.ReflectionHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;

public class IsolatedHashMapTest
extends JUnitTestCase {
    private static final char SEPARATOR = '$';
    private static final String DEFAULT_PARTITION_ID = "0";
    private static final Map<String, String> map = IsolatedHashMap.newMap();
    private static final ServerPlatform serverPlatform;
    private static final boolean supportPartitions;
    private static final String[] sessionNameTemplates;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("IsolatedHashMapTest");
        suite.addTest((Test)new IsolatedHashMapTest("testIsolationInRealContext"));
        suite.addTest((Test)new IsolatedHashMapTest("testIsolationInMockedContext"));
        return suite;
    }

    private static String[] initSessionNames(String partitionId) {
        int count = sessionNameTemplates.length;
        String[] sessionNames = new String[count];
        int maxLength = 0;
        for (int i = 0; i < count; ++i) {
            int sessionNameTemplateLength = sessionNameTemplates[i].length();
            if (sessionNameTemplateLength <= maxLength) continue;
            maxLength = sessionNameTemplateLength;
        }
        StringBuilder sb = new StringBuilder(maxLength += 1 + partitionId.length());
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.delete(0, sb.length() - 1);
            }
            sb.append(sessionNameTemplates[i]);
            sb.append('$');
            sb.append(partitionId);
            sessionNames[i] = sb.toString();
        }
        return sessionNames;
    }

    public IsolatedHashMapTest() {
    }

    public IsolatedHashMapTest(String name) {
        super(name);
    }

    private static void doIsolationCheck(Map<String, String> map, String partitionId, SessionLog log) {
        String[] sessionNames = IsolatedHashMapTest.initSessionNames(partitionId);
        HashSet<String> namesSet = new HashSet<String>(sessionNames.length);
        log.log(3, "  Partition ID: " + partitionId);
        for (String sessionName : sessionNames) {
            log.log(2, "    Adding session name: " + sessionName);
            map.put(sessionName, sessionName);
            namesSet.add(sessionName);
        }
        IsolatedHashMapTest.assertEquals((String)"Map size does not match session names count.", (int)sessionNames.length, (int)map.size());
        for (String sessionName : map.keySet()) {
            log.log(2, "    Getting and checking session name: " + sessionName);
            IsolatedHashMapTest.assertTrue((String)("Session name " + sessionName + "was not stored in current partition context."), (boolean)namesSet.contains(sessionName));
        }
    }

    public void testIsolationInRealContext() {
        SessionLog log = IsolatedHashMapTest.getServerSession().getSessionLog();
        log.log(5, "IsolatedHashMapTest.testIsolationInRealContext()");
        IsolatedHashMapTest.doIsolationCheck(map, supportPartitions ? serverPlatform.getPartitionID() : DEFAULT_PARTITION_ID, log);
    }

    public void testIsolationInMockedContext() {
        SessionLog log = IsolatedHashMapTest.getServerSession().getSessionLog();
        log.log(5, "IsolatedHashMapTest.testIsolationInMockedContext()");
        TestServerPlatform testPlatform = new TestServerPlatform();
        try {
            String[] partitionIds;
            ServerPlatform originalPlatform = (ServerPlatform)ReflectionHelper.getPrivateStatic(IsolatedHashMap.class, (String)"serverPlatform");
            boolean originalsupport = (Boolean)ReflectionHelper.getPrivateStatic(IsolatedHashMap.class, (String)"supportPartitions");
            log.log(2, "Original platform field instance: " + originalPlatform.getClass().getName());
            log.log(2, "Original partitions support flag: " + Boolean.toString(originalsupport));
            ReflectionHelper.setPrivateStaticFinal(IsolatedHashMap.class, (String)"serverPlatform", (Object)testPlatform);
            ReflectionHelper.setPrivateStaticFinal(IsolatedHashMap.class, (String)"supportPartitions", (Object)testPlatform.usesPartitions());
            Map map = IsolatedHashMap.newMap();
            for (String partitionId : partitionIds = new String[]{"first", "second", "third"}) {
                testPlatform.setPartitionID(partitionId);
                IsolatedHashMapTest.doIsolationCheck(map, partitionId, log);
            }
            ReflectionHelper.setPrivateStaticFinal(IsolatedHashMap.class, (String)"serverPlatform", (Object)originalPlatform);
            ReflectionHelper.setPrivateStaticFinal(IsolatedHashMap.class, (String)"supportPartitions", (Object)originalsupport);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.logThrowable(6, (Throwable)e);
            e.printStackTrace();
        }
    }

    static {
        sessionNameTemplates = new String[]{"", DEFAULT_PARTITION_ID, "mySession", "EclipseLink"};
        serverPlatform = ServerPlatformUtils.createServerPlatform(null, (String)ServerPlatformUtils.detectServerPlatform(null), (ClassLoader)SessionManager.class.getClassLoader());
        supportPartitions = serverPlatform != null ? serverPlatform.usesPartitions() : false;
    }

    private static class TestServerPlatform
    implements ServerPlatform {
        private String partitionId = "0";

        private TestServerPlatform() {
        }

        public boolean usesPartitions() {
            return true;
        }

        public String getPartitionID() {
            return this.partitionId;
        }

        private void setPartitionID(String id) {
            this.partitionId = id;
        }

        public DatabaseSession getDatabaseSession() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getServerNameAndVersion() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getModuleName() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Class getExternalTransactionControllerClass() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setExternalTransactionControllerClass(Class newClass) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void initializeExternalTransactionController() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isJTAEnabled() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isRuntimeServicesEnabledDefault() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void disableJTA() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isRuntimeServicesEnabled() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void disableRuntimeServices() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void registerMBean() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void unregisterMBean() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void shutdown() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public int getThreadPoolSize() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setThreadPoolSize(int threadPoolSize) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Connection unwrapConnection(Connection connection) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void launchContainerRunnable(Runnable runnable) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public SessionLog getServerLog() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean shouldUseDriverManager() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean wasFailureCommunicationBased(SQLException exception, Accessor connection, AbstractSession sessionForProfile) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public JPAClassLoaderHolder getNewTempClassLoader(PersistenceUnitInfo puInfo) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void clearStatementCache(Connection connection) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public int getJNDIConnectorLookupType() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

