/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import org.jivesoftware.smack.packet.PacketExtension;

public class MUCUser
implements PacketExtension {
    private Invite invite;
    private Decline decline;
    private Item item;
    private String password;
    private Status status;
    private Destroy destroy;

    public String getElementName() {
        return "x";
    }

    public String getNamespace() {
        return "http://jabber.org/protocol/muc#user";
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.getInvite() != null) {
            buf.append(this.getInvite().toXML());
        }
        if (this.getDecline() != null) {
            buf.append(this.getDecline().toXML());
        }
        if (this.getItem() != null) {
            buf.append(this.getItem().toXML());
        }
        if (this.getPassword() != null) {
            buf.append("<password>").append(this.getPassword()).append("</password>");
        }
        if (this.getStatus() != null) {
            buf.append(this.getStatus().toXML());
        }
        if (this.getDestroy() != null) {
            buf.append(this.getDestroy().toXML());
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public Invite getInvite() {
        return this.invite;
    }

    public Decline getDecline() {
        return this.decline;
    }

    public Item getItem() {
        return this.item;
    }

    public String getPassword() {
        return this.password;
    }

    public Status getStatus() {
        return this.status;
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setInvite(Invite invite) {
        this.invite = invite;
    }

    public void setDecline(Decline decline) {
        this.decline = decline;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    public static class Decline {
        private String reason;
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<decline ");
            if (this.getTo() != null) {
                buf.append(" to=\"").append(this.getTo()).append("\"");
            }
            if (this.getFrom() != null) {
                buf.append(" from=\"").append(this.getFrom()).append("\"");
            }
            buf.append(">");
            if (this.getReason() != null) {
                buf.append("<reason>").append(this.getReason()).append("</reason>");
            }
            buf.append("</decline>");
            return buf.toString();
        }
    }

    public static class Destroy {
        private String reason;
        private String jid;

        public String getJid() {
            return this.jid;
        }

        public String getReason() {
            return this.reason;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<destroy");
            if (this.getJid() != null) {
                buf.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getReason() == null) {
                buf.append("/>");
            } else {
                buf.append(">");
                if (this.getReason() != null) {
                    buf.append("<reason>").append(this.getReason()).append("</reason>");
                }
                buf.append("</destroy>");
            }
            return buf.toString();
        }
    }

    public static class Invite {
        private String reason;
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTo() {
            return this.to;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<invite ");
            if (this.getTo() != null) {
                buf.append(" to=\"").append(this.getTo()).append("\"");
            }
            if (this.getFrom() != null) {
                buf.append(" from=\"").append(this.getFrom()).append("\"");
            }
            buf.append(">");
            if (this.getReason() != null) {
                buf.append("<reason>").append(this.getReason()).append("</reason>");
            }
            buf.append("</invite>");
            return buf.toString();
        }
    }

    public static class Item {
        private String actor;
        private String reason;
        private String affiliation;
        private String jid;
        private String nick;
        private String role;

        public Item(String affiliation, String role) {
            this.affiliation = affiliation;
            this.role = role;
        }

        public String getActor() {
            return this.actor == null ? "" : this.actor;
        }

        public String getReason() {
            return this.reason == null ? "" : this.reason;
        }

        public String getAffiliation() {
            return this.affiliation;
        }

        public String getJid() {
            return this.jid;
        }

        public String getNick() {
            return this.nick;
        }

        public String getRole() {
            return this.role;
        }

        public void setActor(String actor) {
            this.actor = actor;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public void setNick(String nick) {
            this.nick = nick;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<item");
            if (this.getAffiliation() != null) {
                buf.append(" affiliation=\"").append(this.getAffiliation()).append("\"");
            }
            if (this.getJid() != null) {
                buf.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getNick() != null) {
                buf.append(" nick=\"").append(this.getNick()).append("\"");
            }
            if (this.getRole() != null) {
                buf.append(" role=\"").append(this.getRole()).append("\"");
            }
            if (this.getReason() == null && this.getActor() == null) {
                buf.append("/>");
            } else {
                buf.append(">");
                if (this.getReason() != null) {
                    buf.append("<reason>").append(this.getReason()).append("</reason>");
                }
                if (this.getActor() != null) {
                    buf.append("<actor jid=\"").append(this.getActor()).append("\"/>");
                }
                buf.append("</item>");
            }
            return buf.toString();
        }
    }

    public static class Status {
        private String code;

        public Status(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<status code=\"").append(this.getCode()).append("\"/>");
            return buf.toString();
        }
    }
}

