/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.reviews.ui.wizard.CreateReviewWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReviewAssignmentPage
extends WizardPage {
    private Text reviewerText;
    private Button openOnFinish;

    protected ReviewAssignmentPage() {
        super("ReviewAssignmentPage");
        this.setTitle("Review Assignment");
        this.setDescription("Select the user, who will conduct the review");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(composite, "Reviewer");
        this.reviewerText = new Text(composite, 2048);
        this.reviewerText.setLayoutData((Object)new GridData(4, 128, true, false));
        String userName = ((CreateReviewWizard)this.getWizard()).getModel().getTaskRepository().getUserName();
        if (userName != null) {
            this.setPageComplete(true);
            this.reviewerText.setText(userName);
        }
        this.reviewerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReviewAssignmentPage.this.setPageComplete(!ReviewAssignmentPage.this.reviewerText.getText().isEmpty());
            }
        });
        this.createLabel(composite, "");
        this.openOnFinish = new Button(composite, 32);
        this.openOnFinish.setText("Open review task on finish");
        this.setControl((Control)composite);
    }

    private void createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
    }

    public String getReviewer() {
        return this.reviewerText.getText();
    }

    public boolean isOpenReviewOnFinish() {
        return this.openOnFinish.getSelection();
    }
}

