/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.editors;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.ui.Messages;
import org.eclipse.mylyn.reviews.ui.ReviewCommentTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class UpdateReviewTask
extends Job {
    private TaskDataModel model;
    private Review review;
    private TaskRepository taskRepository;
    private AbstractRepositoryConnector connector;

    public UpdateReviewTask(TaskDataModel model, Review review) {
        super(org.eclipse.mylyn.reviews.ui.editors.Messages.UpdateReviewTask_Title);
        this.model = model;
        this.review = review;
        this.taskRepository = model.getTaskRepository();
        this.connector = TasksUi.getRepositoryConnector((String)this.taskRepository.getConnectorKind());
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            byte[] attachmentBytes = this.createAttachment(this.model, this.review);
            TaskAttribute attachmentAttribute = this.model.getTaskData().getAttributeMapper().createTaskAttachment(this.model.getTaskData());
            try {
                ReviewCommentTaskAttachmentSource attachment = new ReviewCommentTaskAttachmentSource(attachmentBytes);
                monitor.subTask(Messages.CreateTask_UploadingAttachment);
                this.connector.getTaskAttachmentHandler().postContent(this.taskRepository, this.model.getTask(), (AbstractTaskAttachmentSource)attachment, "review result", attachmentAttribute, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return new Status(0, "org.eclipse.mylyn.reviews.ui", Messages.CreateTask_Success);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.mylyn.reviews.ui", e.getMessage());
        }
    }

    private byte[] createAttachment(TaskDataModel model, Review review) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createFileURI((String)""));
            resource.getContents().add((Object)review);
            resource.getContents().add((Object)((EObject)review.getScope().get(0)));
            resource.getContents().add((Object)review.getResult());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream outputStream = new ZipOutputStream(byteArrayOutputStream);
            outputStream.putNextEntry(new ZipEntry("reviews-data.xml"));
            resource.save((OutputStream)outputStream, null);
            outputStream.closeEntry();
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

