/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.editors;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.patch.IFilePatch2;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.core.model.review.Patch;
import org.eclipse.mylyn.reviews.ui.Images;
import org.eclipse.mylyn.reviews.ui.ReviewDiffModel;
import org.eclipse.mylyn.reviews.ui.editors.Messages;
import org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPage;
import org.eclipse.mylyn.reviews.ui.editors.TableLabelProvider;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewTaskEditorPart
extends AbstractTaskEditorPart {
    public static final String ID_PART_REVIEW = "org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPart";
    private TableViewer fileList;
    private TextMergeViewer viewer;
    private Control sashComposite;

    public ReviewTaskEditorPart() {
        this.setPartName("Scope");
        this.setExpandVertically(true);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        GridLayout gl = new GridLayout(1, false);
        gl.marginBottom = 8;
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 4;
        section.setLayout((Layout)gl);
        section.setLayoutData((Object)gd);
        SashForm composite = new SashForm((Composite)section, 256);
        this.sashComposite = composite;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)this.createSectionClientLayout());
        this.fileList = new TableViewer((Composite)composite);
        this.fileList.getControl().setLayoutData((Object)new GridData(-1, 4, false, true));
        TableViewerColumn column = new TableViewerColumn(this.fileList, 16384);
        column.getColumn().setText("");
        column.getColumn().setWidth(25);
        column.getColumn().setResizable(false);
        column = new TableViewerColumn(this.fileList, 16384);
        column.getColumn().setText("Filename");
        column.getColumn().setWidth(100);
        column.getColumn().setResizable(true);
        this.fileList.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){
            private final int COLUMN_ICON = 0;
            private final int COLUMN_FILE = 1;

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1 && element instanceof ReviewDiffModel) {
                    ReviewDiffModel diffModel = (ReviewDiffModel)element;
                    return diffModel.getFileName();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                    if (element instanceof ReviewDiffModel) {
                        ReviewDiffModel diffModel = (ReviewDiffModel)element;
                        if (diffModel.isNewFile()) {
                            return new NewFile().createImage();
                        }
                        if (!diffModel.canReview()) {
                            return new MissingFile().createImage();
                        }
                    }
                    return sharedImages.getImage("IMG_OBJ_FILE");
                }
                return null;
            }
        });
        this.fileList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Patch patch = (Patch)inputElement;
                EList patches = patch.parse();
                Object[] model = new ReviewDiffModel[patches.size()];
                int index = 0;
                for (IFilePatch2 currentPatch : patches) {
                    PatchConfiguration configuration = new PatchConfiguration();
                    currentPatch.getTargetPath(configuration);
                    model[index++] = new ReviewDiffModel(currentPatch, configuration);
                }
                return model;
            }
        });
        this.fileList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReviewDiffModel diffModel;
                IStructuredSelection sel;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).getFirstElement() instanceof ReviewDiffModel && (diffModel = (ReviewDiffModel)sel.getFirstElement()).canReview()) {
                    ReviewTaskEditorPart.this.viewer.setInput((Object)diffModel.getCompareInput());
                }
            }
        });
        this.fileList.setInput(this.getTaskEditorPage().getReview().getScope().get(0));
        CompareConfiguration configuration = new CompareConfiguration();
        configuration.setLeftEditable(false);
        configuration.setRightEditable(false);
        configuration.setLeftLabel(Messages.EditorSupport_Original);
        configuration.setRightLabel(Messages.EditorSupport_Patched);
        configuration.setProperty("IGNORE_WHITESPACE", (Object)false);
        configuration.setProperty("USE_OUTLINE_VIEW", (Object)true);
        this.viewer = new TextMergeViewer((Composite)composite, 2048, configuration);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setInput((Object)this.getDiffEditorNullInput());
        composite.setWeights(new int[]{1, 3});
        section.setClient((Control)composite);
        this.setSection(toolkit, section);
    }

    private DiffNode getDiffEditorNullInput() {
        return new DiffNode((ITypedElement)new DiffNode(16384), (ITypedElement)new DiffNode(131072));
    }

    public ReviewTaskEditorPage getTaskEditorPage() {
        return (ReviewTaskEditorPage)super.getTaskEditorPage();
    }

    private GridLayout createSectionClientLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginTop = 2;
        layout.marginBottom = 8;
        return layout;
    }

    public Control getSashComposite() {
        return this.sashComposite;
    }

    protected void fillToolBar(ToolBarManager manager) {
        super.fillToolBar(manager);
    }

    private static class MissingFile
    extends CompositeImageDescriptor {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        private ImageData baseImage;

        private MissingFile() {
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getBaseImageData(), 0, 0);
            this.drawImage(Images.OVERLAY_OBSTRUCTED.getImageData(), 7, 3);
        }

        protected Point getSize() {
            ImageData img = this.getBaseImageData();
            return new Point(img.width, img.height);
        }

        private ImageData getBaseImageData() {
            if (this.baseImage == null) {
                this.baseImage = this.sharedImages.getImageDescriptor("IMG_OBJ_FILE").getImageData();
            }
            return this.baseImage;
        }
    }

    private static class NewFile
    extends CompositeImageDescriptor {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        private ImageData baseImage;

        private NewFile() {
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getBaseImageData(), 0, 0);
            this.drawImage(Images.OVERLAY_ADDITION.getImageData(), 7, 5);
        }

        protected Point getSize() {
            ImageData img = this.getBaseImageData();
            return new Point(img.width, img.height);
        }

        private ImageData getBaseImageData() {
            if (this.baseImage == null) {
                this.baseImage = this.sharedImages.getImageDescriptor("IMG_OBJ_FILE").getImageData();
            }
            return this.baseImage;
        }
    }
}

