/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.reviews.ui.Images;
import org.eclipse.mylyn.reviews.ui.Messages;
import org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPage;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;

public class ReviewTaskEditorPageFactory
extends AbstractTaskEditorPageFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canCreatePageFor(TaskEditorInput input) {
        ITask task = input.getTask();
        try {
            ITaskAttachment taskAttachment;
            TaskData taskData = TasksUi.getTaskDataManager().getTaskData(task);
            if (taskData == null) return false;
            List attributesByType = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
            Iterator iterator = attributesByType.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                TaskAttribute attribute = (TaskAttribute)iterator.next();
                taskAttachment = ((RepositoryModel)TasksUi.getRepositoryModel()).createTaskAttachment(attribute);
                taskData.getAttributeMapper().updateTaskAttachment(taskAttachment, attribute);
            } while (!taskAttachment.getFileName().equals("review-data.zip"));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public IFormPage createPage(TaskEditor parentEditor) {
        return new ReviewTaskEditorPage(parentEditor);
    }

    public Image getPageImage() {
        return Images.SMALL_ICON.createImage();
    }

    public String getPageText() {
        return Messages.ReviewTaskEditorPageFactory_PageTitle;
    }

    public int getPriority() {
        return 100;
    }

    public String[] getConflictingIds(TaskEditorInput input) {
        return new String[]{"org.eclipse.mylyn.bugzilla.ui.pageFactory"};
    }
}

