/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.modisco.facet.util.ui.internal.exported.tree.menu.ITreeMenu;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.ExtendedTree;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.item.AbstractTreeItem;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeMenu;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeMenuItem;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeSubMenu;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExtendedTreeMenu<IDialog>
implements ITreeMenu<IDialog> {
    private final Control parent;
    private final ExtendedTree treeExtended;
    private final List<AbstractTreeMenu<IDialog>> menuItems;
    private Menu menu;

    public ExtendedTreeMenu(Control parent, ExtendedTree treeExtended, List<AbstractTreeMenu<IDialog>> menuItems) {
        this.parent = parent;
        this.treeExtended = treeExtended;
        this.menuItems = menuItems;
    }

    public void createMenu() {
        this.menu = new Menu(this.parent);
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent menuEvent) {
                ExtendedTreeMenu.this.onMenuShown();
            }

            public void menuHidden(MenuEvent menuEvent) {
            }
        });
    }

    public void onMenuShown() {
        for (AbstractTreeMenu<IDialog> menuItem : this.getMenuItems()) {
            menuItem.refresh(this);
        }
    }

    public List<AbstractTreeMenu<IDialog>> getTreeMenuItems() {
        return this.getMenuItems();
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void putExtraProperties(Map<String, Object> properties) {
        for (AbstractTreeMenu<IDialog> menuItem : this.getMenuItems()) {
            menuItem.setExtraProperties(properties);
        }
    }

    public TreeItem getCurrentItemSelected() {
        TreeItem result = null;
        TreeItem[] items = this.treeExtended.getTree().getSelection();
        if (items.length > 0) {
            result = this.treeExtended.getTree().getSelection()[0];
        }
        return result;
    }

    public AbstractTreeItem<IDialog> getTreeItemExtended(TreeItem treeItem) {
        AbstractTreeItem<IDialog> result = null;
        for (AbstractTreeMenu<IDialog> menuItem : this.getMenuItems()) {
            AbstractTreeItem<IDialog> itemExtended = menuItem.getTreeItemExtended(treeItem);
            if (itemExtended == null) continue;
            result = itemExtended;
            break;
        }
        return result;
    }

    public AbstractTreeMenu<IDialog> getTreeMenu(TreeItem treeItem) {
        AbstractTreeMenu<IDialog> result = null;
        for (AbstractTreeMenu<IDialog> menuItem : this.getMenuItems()) {
            AbstractTreeItem<IDialog> itemExtended = menuItem.getTreeItemExtended(treeItem);
            if (itemExtended == null) continue;
            result = menuItem;
            break;
        }
        return result;
    }

    public void removeCurrentItemSelected() {
        AbstractTreeMenu<IDialog> treeMenu = this.getTreeMenu(this.getCurrentItemSelected());
        if (treeMenu != null) {
            treeMenu.removeItem(this.getCurrentItemSelected());
        }
    }

    public Tree getTree() {
        return this.treeExtended.getTree();
    }

    public void onMouseSelection() {
        AbstractTreeItem<IDialog> treeMenu = this.getTreeItemExtended(this.getCurrentItemSelected());
        if (treeMenu != null) {
            treeMenu.onItemMouseSelection();
            this.fireChanged();
        }
    }

    public void fireChanged() {
        this.treeExtended.fireChanged();
    }

    private List<AbstractTreeMenu<IDialog>> getMenuItems() {
        return this.menuItems;
    }

    @Override
    public IDialog selectMenuItem(Class<? extends AbstractTreeMenuItem<IDialog>> menuItemType) {
        IDialog result = null;
        AbstractTreeMenuItem<IDialog> treeMenu = this.findMenuItem(menuItemType);
        if (treeMenu != null) {
            result = (IDialog)((AbstractTreeMenu)treeMenu).onMenuItemSelection();
        }
        return result;
    }

    private AbstractTreeMenuItem<IDialog> findMenuItem(Class<? extends AbstractTreeMenuItem<IDialog>> menuItemType) {
        AbstractTreeMenuItem<IDialog> result = null;
        for (AbstractTreeMenuItem<IDialog> item : this.getAllTreeMenuItems()) {
            if (!item.getClass().isInstance(menuItemType)) continue;
            result = item;
        }
        return result;
    }

    private List<AbstractTreeMenuItem<IDialog>> getAllTreeMenuItems() {
        LinkedList<AbstractTreeMenuItem<IDialog>> result = new LinkedList<AbstractTreeMenuItem<IDialog>>();
        for (AbstractTreeMenu<IDialog> menuItem : this.getMenuItems()) {
            if (menuItem instanceof AbstractTreeSubMenu) {
                result.addAll(this.getAllTreeMenuItems((AbstractTreeSubMenu)menuItem));
                continue;
            }
            result.add((AbstractTreeMenuItem)menuItem);
        }
        return result;
    }

    private List<AbstractTreeMenuItem<IDialog>> getAllTreeMenuItems(AbstractTreeSubMenu<IDialog> subMenu) {
        LinkedList<AbstractTreeMenuItem<IDialog>> result = new LinkedList<AbstractTreeMenuItem<IDialog>>();
        for (AbstractTreeMenu<IDialog> menuItem : subMenu.getItems()) {
            if (menuItem instanceof AbstractTreeSubMenu) {
                result.addAll(this.getAllTreeMenuItems((AbstractTreeSubMenu)menuItem));
                continue;
            }
            result.add((AbstractTreeMenuItem)menuItem);
        }
        return result;
    }

    public AbstractTreeMenu<IDialog> getTreeMenuItem(Class<?> treeMenuType) {
        AbstractTreeMenu<IDialog> result = null;
        List<AbstractTreeMenu<IDialog>> treeMenuItems = this.getTreeMenuItems();
        for (AbstractTreeMenu<IDialog> item : treeMenuItems) {
            result = this.getTreeMenuItem(item, treeMenuType);
            if (result != null) break;
        }
        return result;
    }

    private AbstractTreeMenu<IDialog> getTreeMenuItem(AbstractTreeSubMenu<IDialog> item, Class<?> treeMenuType) {
        AbstractTreeMenu<IDialog> result = null;
        for (AbstractTreeMenu<IDialog> subItem : item.getItems()) {
            result = this.getTreeMenuItem(subItem, treeMenuType);
            if (result != null) break;
        }
        return result;
    }

    private AbstractTreeMenu<IDialog> getTreeMenuItem(AbstractTreeMenu<IDialog> item, Class<?> treeMenuType) {
        AbstractTreeMenu<IDialog> result = null;
        if (treeMenuType.isInstance(item)) {
            result = item;
        } else if (item instanceof AbstractTreeSubMenu) {
            result = this.getTreeMenuItem((AbstractTreeSubMenu)item, treeMenuType);
        }
        return result;
    }

    @Override
    public List<AbstractTreeItem<IDialog>> getTreeItems(String treeItemName) {
        LinkedList<AbstractTreeItem<IDialog>> result = new LinkedList<AbstractTreeItem<IDialog>>();
        for (AbstractTreeMenuItem<IDialog> menuItem : this.getAllTreeMenuItems()) {
            for (AbstractTreeItem<IDialog> treeItem : menuItem.getItems()) {
                if (!treeItemName.equals(treeItem.getItemText())) continue;
                result.add(treeItem);
            }
        }
        return result;
    }

    public void selectTreeItem(AbstractTreeItem<IDialog> treeItem) {
        this.treeExtended.getTree().setSelection(treeItem.getTreeItem());
    }
}

