/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;

public class ImportToNonTransformCtxHelper {
    private final HashMap<Module, ModuleInstance> fInstanceMap;
    private final LinkedHashSet<Module> fImportedModules;
    private final boolean fIncludeStdLib;
    private final ModuleInstanceCachingFactory fModuleFactory;

    public ImportToNonTransformCtxHelper(LinkedHashSet<Module> importedModules, boolean includeStdLib) {
        if (importedModules == null) {
            throw new IllegalArgumentException("non-null module set required");
        }
        this.fIncludeStdLib = includeStdLib;
        this.fImportedModules = new LinkedHashSet<Module>(importedModules);
        this.fInstanceMap = new HashMap();
        this.fModuleFactory = new ModuleInstanceCachingFactory();
    }

    public ImportToNonTransformCtxHelper() {
        this(new LinkedHashSet<Module>(1), true);
    }

    public boolean addImportedModule(Module module) {
        if (module == null) {
            throw new IllegalArgumentException();
        }
        if (this.fImportedModules.contains(module)) {
            return false;
        }
        return this.fImportedModules.add(module);
    }

    public Set<Module> getModules() {
        return Collections.unmodifiableSet(this.fImportedModules);
    }

    public Map<Module, ModuleInstance> getModuleInstances() {
        return Collections.unmodifiableMap(this.fInstanceMap);
    }

    ThisInstanceResolver createImportedInstanceResolver() {
        return this.fModuleFactory.createImportedInstanceResolver();
    }

    List<ModuleInstance> getModuleInstances(boolean initialized) {
        ArrayList<ModuleInstance> result = new ArrayList<ModuleInstance>();
        for (Module nextModule : this.fImportedModules) {
            ModuleInstance moduleInstance = this.fInstanceMap.get(nextModule);
            assert (moduleInstance != null);
            if (initialized != moduleInstance.getAdapter(ModuleInstance.Internal.class).isInitialized()) continue;
            result.add(moduleInstance);
        }
        return result;
    }

    private class ModuleInstanceCachingFactory
    extends ModuleInstanceFactory {
        private ModuleInstanceCachingFactory() {
        }

        public ThisInstanceResolver createImportedInstanceResolver() {
            if (ImportToNonTransformCtxHelper.this.fIncludeStdLib) {
                this.basicCreateModuleInstance(QvtOperationalStdLibrary.INSTANCE.getStdLibModule(), ImportToNonTransformCtxHelper.this.fInstanceMap, null);
            }
            for (Module module : ImportToNonTransformCtxHelper.this.fImportedModules) {
                this.createModuleInstance(module, ImportToNonTransformCtxHelper.this.fInstanceMap, null);
            }
            return new ThisInstanceResolver(){

                @Override
                public ModuleInstance getThisInstanceOf(Module module) {
                    return (ModuleInstance)ImportToNonTransformCtxHelper.this.fInstanceMap.get(module);
                }
            };
        }
    }
}

