/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.filtering;

import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.DeploymentDescriptorManagement;
import org.eclipse.m2e.wtp.EarPluginConfiguration;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.internal.filtering.ResourceFilteringBuildParticipant;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferencesManager;

public class EarResourceBuildParticipant
extends ResourceFilteringBuildParticipant {
    @Override
    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        IFolder earResourcesFolder;
        super.build(kind, monitor);
        IMavenProjectFacade facade = this.getMavenProjectFacade();
        IProject project = facade.getProject();
        MavenProject mavenProject = facade.getMavenProject(monitor);
        EarPluginConfiguration config = new EarPluginConfiguration(mavenProject);
        if (!config.isGenerateApplicationXml()) {
            return null;
        }
        IMavenWtpPreferencesManager prefMgr = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager();
        boolean useBuildDirectory = prefMgr.getPreferences(project).isApplicationXmGeneratedInBuildDirectory();
        if (useBuildDirectory) {
            String appResourcesDir = ProjectUtils.getM2eclipseWtpFolder(mavenProject, project).toPortableString() + "/ear-resources";
            earResourcesFolder = project.getFolder(appResourcesDir);
        } else {
            earResourcesFolder = project.getFolder(config.getEarContentDirectory(project));
        }
        if (!earResourcesFolder.getFile("META-INF/application.xml").exists()) {
            DeploymentDescriptorManagement.INSTANCE.updateConfiguration(project, mavenProject, config, useBuildDirectory, monitor);
        }
        return null;
    }
}

