/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.config.ConfigurationProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.ui.services.IImageService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageService
implements IImageService {
    @Override
    public ImageDescriptor getImageDescriptorForId(String providerId, String imageId) {
        if (imageId == null || providerId == null) {
            return null;
        }
        String registryKey = this.makeKey(providerId, imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        imageDescriptor = this.createImageDescriptorForId(providerId, imageId);
        return imageDescriptor;
    }

    @Override
    public Image getImageForId(String providerId, String imageId) {
        if (imageId == null || providerId == null) {
            return null;
        }
        String registryKey = this.makeKey(providerId, imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        Image result = imageRegistry.get(registryKey);
        if (result != null && !result.isDisposed()) {
            return result;
        }
        this.createImageDescriptorForId(providerId, imageId);
        Image image = imageRegistry.get(registryKey);
        if (image == null) {
            throw new IllegalStateException("No image could be retrieved for imageId '" + imageId + "'");
        }
        return image;
    }

    @Override
    public void removeImageFromRegistry(String key) {
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        imageRegistry.remove(key);
    }

    @Override
    public ImageDescriptor getPlatformImageDescriptorForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        String registryKey = this.makePlatformKey(imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        imageDescriptor = this.createPlatformImageDescriptorForId(imageId);
        return imageDescriptor;
    }

    @Override
    public Image getPlatformImageForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        String registryKey = this.makePlatformKey(imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        Image result = imageRegistry.get(registryKey);
        if (result != null && !result.isDisposed()) {
            return result;
        }
        this.createPlatformImageDescriptorForId(imageId);
        Image image = imageRegistry.get(registryKey);
        if (image == null) {
            throw new IllegalStateException("No image could be retrieved for imageId '" + imageId + "'");
        }
        return image;
    }

    @Override
    public byte[] convertImageToBytes(Image image, int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            try {
                ImageData imDat = null;
                if (format == 2) {
                    imDat = this.create8BitIndexedPaletteImage(image);
                }
                if (imDat == null) {
                    imDat = image.getImageData();
                }
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{imDat};
                try {
                    imageLoader.save((OutputStream)result, format);
                }
                catch (SWTException e) {
                    String error = "Depth: " + Integer.toString(image.getImageData().depth) + "\nX: " + Integer.toString(image.getImageData().x) + "\nY: " + Integer.toString(image.getImageData().y);
                    throw new IllegalStateException(error, e);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            image.dispose();
        }
        return result.toByteArray();
    }

    private ImageDescriptor fixImageDescriptor(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        return ImageDescriptor.createFromImageData((ImageData)data);
    }

    private ImageDescriptor createImageDescriptorForId(String providerId, String imageId) {
        if (imageId == null || providerId == null) {
            return null;
        }
        String registryKey = this.makeKey(providerId, imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Collection<IImageProvider> imageProviders = ExtensionManager.getSingleton().getImageProvidersForDiagramTypeProviderId(providerId);
        for (IImageProvider imageProvider : imageProviders) {
            String imageFilePath = imageProvider.getImageFilePath(imageId);
            if (imageFilePath == null) continue;
            if (imageFilePath.startsWith("bundleentry://") || imageFilePath.startsWith("bundleresource://")) {
                try {
                    URL imageFileUrl = new URL(imageFilePath);
                    imageDescriptor = ImageDescriptor.createFromURL((URL)imageFileUrl);
                }
                catch (MalformedURLException e) {
                    T.racer().error("Bundle entry/resource url for image could not be parsed, url was: " + imageFilePath, e);
                }
                break;
            }
            String pluginId = imageProvider.getPluginId();
            if (pluginId == null) break;
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageFilePath);
            break;
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        imageDescriptor = this.fixImageDescriptor(imageDescriptor);
        imageRegistry.put(registryKey, imageDescriptor);
        return imageDescriptor;
    }

    private ImageDescriptor createPlatformImageDescriptorForId(String imageId) {
        String pluginId;
        if (imageId == null) {
            return null;
        }
        String registryKey = this.makePlatformKey(imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        IImageProvider platformImageProvider = ExtensionManager.getSingleton().getPlatformImageProvider();
        String imageFilePath = platformImageProvider.getImageFilePath(imageId);
        if (imageFilePath != null && (pluginId = platformImageProvider.getPluginId()) != null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageFilePath);
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        imageDescriptor = this.fixImageDescriptor(imageDescriptor);
        imageRegistry.put(registryKey, imageDescriptor);
        return imageDescriptor;
    }

    private String makeKey(String dtp, String imageId) {
        return dtp + "||" + imageId;
    }

    private String makePlatformKey(String imageId) {
        return this.makeKey("org.eclipse.graphiti.ui.platform.PlatformImageProvider", imageId);
    }

    private ImageData create8BitIndexedPaletteImage(Image image) {
        int upperboundWidth = image.getBounds().width;
        int upperboundHeight = image.getBounds().height;
        ImageData imageData = image.getImageData();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        int x = 0;
        while (x < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x, y);
                Integer colorInteger = new Integer(color);
                if (!colors.contains(colorInteger)) {
                    colors.add(colorInteger);
                }
                ++y;
            }
            ++x;
        }
        if (colors.size() > 256) {
            throw new IllegalStateException("Image contains more than 256 colors. \n Automated color reduction is currently not supported.");
        }
        RGB[] rgbs = new RGB[256];
        int i = 0;
        while (i < 256) {
            rgbs[i] = new RGB(255, 255, 255);
            ++i;
        }
        i = 0;
        while (i < colors.size()) {
            int pixelValue = (Integer)colors.get(i);
            int red = (pixelValue & imageData.palette.redMask) >>> Math.abs(imageData.palette.redShift);
            int green = (pixelValue & imageData.palette.greenMask) >>> Math.abs(imageData.palette.greenShift);
            int blue = (pixelValue & imageData.palette.blueMask) >>> Math.abs(imageData.palette.blueShift);
            rgbs[i] = new RGB(red, green, blue);
            ++i;
        }
        PaletteData palette = new PaletteData(rgbs);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, palette);
        int x2 = 0;
        while (x2 < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x2, y);
                newImageData.setPixel(x2, y, colors.indexOf(new Integer(color)));
                ++y;
            }
            ++x2;
        }
        return newImageData;
    }

    @Override
    public byte[] convertDiagramToBytes(Diagram diagram, int format) {
        DummyEditor dummyEditor = new DummyEditor();
        dummyEditor.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        ImageGenerationDiagramBehavior imageGenerationDiagramBehavior = new ImageGenerationDiagramBehavior(dummyEditor, diagram);
        dummyEditor.getGraphicalViewer().setEditPartFactory((EditPartFactory)((IConfigurationProviderInternal)imageGenerationDiagramBehavior.getConfigurationProvider()).getEditPartFactory());
        dummyEditor.getGraphicalViewer().setContents((Object)diagram);
        int width = diagram.getGraphicsAlgorithm().getWidth();
        int height = diagram.getGraphicsAlgorithm().getHeight();
        IFigure diagramFigure = ((LayerManager)dummyEditor.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Printable Layers");
        diagramFigure.setBounds(new Rectangle(0, 0, width, height));
        diagramFigure.validate();
        DiagramEditPart diagramEditPart = (DiagramEditPart)dummyEditor.getGraphicalViewer().getRootEditPart().getChildren().get(0);
        int XMin = width;
        int YMin = height;
        int XMax = 0;
        int YMax = 0;
        for (Object o : diagramEditPart.getFigure().getChildren()) {
            Figure f = (Figure)o;
            if (f.getLocation().x < XMin) {
                XMin = f.getLocation().x;
            }
            if (f.getLocation().y < YMin) {
                YMin = f.getLocation().y;
            }
            if (f.getLocation().x + f.getBounds().width > XMax) {
                XMax = f.getLocation().x + f.getBounds().width;
            }
            if (f.getLocation().y + f.getBounds().height <= YMax) continue;
            YMax = f.getLocation().y + f.getBounds().height;
        }
        width = XMin + XMax;
        height = YMin + YMax;
        if (width > diagramFigure.getBounds().width || height > diagramFigure.getBounds().height) {
            diagramFigure.setBounds(new Rectangle(0, 0, width, height));
            diagramFigure.validate();
        }
        Image diagramImage = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)diagramImage);
        SWTGraphics graphics = new SWTGraphics(gc);
        diagramFigure.paint((Graphics)graphics);
        graphics.dispose();
        gc.dispose();
        return this.convertImageToBytes(diagramImage, format);
    }

    private class DummyEditor
    extends DiagramEditor {
        private DummyGraphicalViewer dummyGraphicalViewer;

        private DummyEditor() {
            this.dummyGraphicalViewer = new DummyGraphicalViewer();
        }

        @Override
        public GraphicalViewer getGraphicalViewer() {
            return this.dummyGraphicalViewer;
        }
    }

    private class DummyGraphicalViewer
    extends AbstractEditPartViewer
    implements GraphicalViewer {
        private DummyGraphicalViewer() {
        }

        public EditPart findObjectAtExcluding(Point location, Collection exclusionSet, EditPartViewer.Conditional conditional) {
            return null;
        }

        public Handle findHandleAt(Point p) {
            return null;
        }

        public Control createControl(Composite parent) {
            return null;
        }
    }

    private class ImageGenerationDiagramBehavior
    extends DiagramBehavior {
        private IConfigurationProviderInternal configurationProvider;

        public ImageGenerationDiagramBehavior(IDiagramContainerUI diagramContainer, Diagram diagram) {
            super(diagramContainer);
            this.configurationProvider = null;
            IDiagramTypeProvider diagramTypeProvider = null;
            String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
            if (providerId != null) {
                diagramTypeProvider = ExtensionManager.getSingleton().createDiagramTypeProvider(providerId);
            }
            if (diagramTypeProvider == null) {
                diagramTypeProvider = ExtensionManager.getSingleton().createDiagramTypeProvider("org.eclipse.graphiti.ui.internal.ExportDiagramAsImageDummyDiagramTypeProvider");
            }
            diagramTypeProvider.init(diagram, (IDiagramBehavior)this);
            this.configurationProvider = new ConfigurationProvider(this, diagramTypeProvider);
        }

        @Override
        public IConfigurationProvider getConfigurationProvider() {
            return this.configurationProvider;
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        @Override
        public DefaultRefreshBehavior getRefreshBehavior() {
            return new DefaultRefreshBehavior(this);
        }
    }
}

