/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.providers;

import com.google.inject.Provider;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class ResizableTransformableBoundsProvider
extends IAdaptable.Bound.Impl<IVisualPart<? extends Node>>
implements Provider<IGeometry> {
    public IGeometry get() {
        double h;
        double w;
        double y;
        double x;
        IVisualPart part = (IVisualPart)this.getAdaptable();
        Bounds boundsInParent = part.getVisual().getBoundsInLocal();
        if (part instanceof IBendableContentPart) {
            boolean isEmpty = true;
            List<IBendableContentPart.BendPoint> bendPoints = ((IBendableContentPart)part).getVisualBendPoints();
            for (IBendableContentPart.BendPoint bp : bendPoints) {
                if (bp.isAttached()) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                return null;
            }
            Affine visualTransform = ((ITransformableContentPart)part).getVisualTransform();
            x = visualTransform.getTx();
            y = visualTransform.getTy();
        } else {
            x = boundsInParent.getMinX();
            y = boundsInParent.getMinY();
        }
        if (part instanceof IBendableContentPart) {
            Dimension visualSize = ((IResizableContentPart)part).getVisualSize();
            w = visualSize.width;
            h = visualSize.height;
        } else {
            w = boundsInParent.getWidth();
            h = boundsInParent.getHeight();
        }
        return new Rectangle(x, y, w, h);
    }
}

