/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.operations.ISystemRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public final class SystemJobRunnableContext
implements ISystemRunnableContext {
    private IJobChangeListener listener;
    private IWorkbenchSite site;
    private String jobName;
    private ISchedulingRule schedulingRule;
    private boolean postponeBuild;
    private boolean isUser;
    private URL icon;
    private boolean keep;
    private IAction action;
    static /* synthetic */ Class class$0;

    public SystemJobRunnableContext(String jobName) {
        this(jobName, null, null, false, null, null);
    }

    public SystemJobRunnableContext(String jobName, URL icon, IAction action, boolean keep, IJobChangeListener listener, IWorkbenchSite site) {
        this.jobName = jobName;
        this.listener = listener;
        this.site = site;
        this.isUser = true;
        this.action = action;
        this.icon = icon;
        this.keep = keep;
    }

    public void run(IRunnableWithProgress runnable) {
        Job job;
        if (this.schedulingRule == null && !this.postponeBuild) {
            job = this.getBasicJob(runnable);
        } else {
            job = this.getWorkspaceJob(runnable);
            if (this.schedulingRule != null) {
                job.setRule(this.schedulingRule);
            }
        }
        if (this.listener != null) {
            job.addJobChangeListener(this.listener);
        }
        job.setUser(this.isUser());
        this.configureJob(job);
        SystemJobRunnableContext.schedule(job, this.site);
    }

    private void configureJob(Job job) {
        if (this.keep) {
            job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
        }
        if (this.action != null) {
            job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)this.action);
        }
        if (this.icon != null) {
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)this.icon);
        }
    }

    public Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public boolean isPostponeBuild() {
        return this.postponeBuild;
    }

    public void setPostponeBuild(boolean postponeBuild) {
        this.postponeBuild = postponeBuild;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public void setUser(boolean isUser) {
        this.isUser = isUser;
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    IStatus run(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            String msg = "";
            if (target != null) {
                msg = target.getMessage();
            }
            return new Status(4, RSEUIPlugin.getDefault().getSymbolicName(), 0, msg, target);
        }
        catch (InterruptedException e) {
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }

    private Job getBasicJob(final IRunnableWithProgress runnable) {
        return new Job(this.jobName){

            public IStatus run(IProgressMonitor monitor) {
                return SystemJobRunnableContext.this.run(runnable, monitor);
            }
        };
    }

    private Job getWorkspaceJob(final IRunnableWithProgress runnable) {
        return new WorkspaceJob(this.jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                return SystemJobRunnableContext.this.run(runnable, monitor);
            }
        };
    }

    public static void schedule(Job job, IWorkbenchSite site) {
        if (site != null) {
            IWorkbenchSiteProgressService siteProgress;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((siteProgress = (IWorkbenchSiteProgressService)site.getAdapter((Class)clazz)) != null) {
                siteProgress.schedule(job, 0L, true);
                return;
            }
        }
        job.schedule();
    }
}

