/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtPosition;
import org.eclipse.ocl.cst.CSTNode;

class FoldingStructureUpdater
implements IQVTReconcilingListener {
    private Annotation[] myAnnotations = new Annotation[0];
    private ProjectionViewer myViewer;

    public FoldingStructureUpdater(ProjectionViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this.myViewer = viewer;
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(CompiledUnit unit, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        List<Position> newFoldingPositions = Collections.emptyList();
        if (unit != null) {
            newFoldingPositions = this.getNewFoldingPositions(unit);
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.updateFoldingStructure(newFoldingPositions, monitor);
    }

    private List<Position> getNewFoldingPositions(CompiledUnit compilationResult) {
        ArrayList<Position> positions = new ArrayList<Position>();
        UnitCS unitCST = compilationResult.getUnitCST();
        this.addListPosition((List<? extends CSTNode>)unitCST.getImports(), positions);
        this.addListPosition((List<? extends CSTNode>)unitCST.getModelTypes(), positions);
        for (MappingModuleCS mappingModuleCS : unitCST.getModules()) {
            for (ClassifierDefCS classifierDefCS : mappingModuleCS.getClassifierDefCS()) {
                positions.add(this.createPosition(classifierDefCS.getStartOffset(), classifierDefCS.getEndOffset()));
            }
            for (MappingMethodCS method : mappingModuleCS.getMethods()) {
                positions.add(this.createPosition(method.getStartOffset(), method.getEndOffset()));
            }
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFoldingStructure(List<Position> positions, IProgressMonitor monitor) {
        if (this.myViewer == null || this.myViewer.getProjectionAnnotationModel() == null) {
            return;
        }
        ProjectionAnnotationModel model = this.myViewer.getProjectionAnnotationModel();
        LinkedHashMap<ProjectionAnnotation, Position> newAnnotationMap = new LinkedHashMap<ProjectionAnnotation, Position>();
        for (Position position : positions) {
            if (monitor.isCanceled()) {
                return;
            }
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotationMap.put(annotation, position);
        }
        Object object = this.getLockObject((IAnnotationModel)model);
        synchronized (object) {
            model.replaceAnnotations(this.myAnnotations, newAnnotationMap);
        }
        this.myAnnotations = newAnnotationMap.keySet().toArray(new Annotation[newAnnotationMap.size()]);
    }

    private void addListPosition(List<? extends CSTNode> list, List<Position> positionList) {
        if (!list.isEmpty()) {
            int start = this.getStart(list);
            int end = this.getEnd(list);
            if (start >= 0 && end >= start) {
                positionList.add(this.createPosition(start, end));
            }
        }
    }

    private int getStart(List<? extends CSTNode> list) {
        int start = Integer.MAX_VALUE;
        for (CSTNode cSTNode : list) {
            if (cSTNode == null) continue;
            start = Math.min(start, cSTNode.getStartOffset());
        }
        return start;
    }

    private int getEnd(List<? extends CSTNode> list) {
        int end = -1;
        for (CSTNode cSTNode : list) {
            if (cSTNode == null) continue;
            end = Math.max(end, cSTNode.getEndOffset());
        }
        return end;
    }

    private QvtPosition createPosition(int start, int end) {
        Region region = new Region(start, end - start);
        IRegion normalized = this.alignRegion((IRegion)region);
        if (normalized != null) {
            region = normalized;
        }
        return new QvtPosition(region.getOffset(), region.getLength());
    }

    private final IRegion alignRegion(IRegion region) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = this.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException x) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private IDocument getDocument() {
        return this.myViewer.getDocument();
    }
}

