/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.spi.cdo.AbstractConflictResolver;
import org.eclipse.emf.spi.cdo.CDOChangeSubscriptionAdapter;
import org.eclipse.emf.spi.cdo.CDOSessionInvalidationEventQueue;

public abstract class AbstractChangeSetsConflictResolver
extends AbstractConflictResolver
implements CDOConflictResolver.NonConflictAware {
    private CDOTransactionHandler handler = new CDODefaultTransactionHandler(){

        @Override
        public void attachingObject(CDOTransaction transaction, CDOObject object) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.transactionAttachingObject(object);
            }
        }

        @Override
        public void detachingObject(CDOTransaction transaction, CDOObject object) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.transactionDetachingObject(object);
            }
        }

        @Override
        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.transactionModifyingObject(object, featureDelta);
            }
        }

        @Override
        public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.transactionCommitting(commitContext);
            }
        }

        @Override
        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.transactionCommitted(commitContext);
            }
        }

        @Override
        public void rolledBackTransaction(CDOTransaction transaction) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction && transaction.getLastSavepoint().getPreviousSavepoint() == null) {
                AbstractChangeSetsConflictResolver.this.transactionRolledBack();
            }
        }
    };
    private CDOChangeSubscriptionAdapter adapter;
    private RemoteInvalidationEventQueue remoteInvalidationEvents;
    private boolean ensureRemoteNotifications = true;
    private long remoteTimeStamp;

    public AbstractChangeSetsConflictResolver() {
    }

    public AbstractChangeSetsConflictResolver(boolean ensureRemoteNotifications) {
        this.ensureRemoteNotifications = ensureRemoteNotifications;
    }

    public CDOChangeSetData getLocalChangeSetData() {
        return this.getTransaction().getChangeSetData();
    }

    public CDOChangeSet getLocalChangeSet() {
        CDOChangeSetData changeSetData = this.getLocalChangeSetData();
        return this.createChangeSet(changeSetData);
    }

    public CDOChangeSetData getRemoteChangeSetData() {
        return this.remoteInvalidationEvents.poll();
    }

    public CDOChangeSet getRemoteChangeSet() {
        this.remoteTimeStamp = 0L;
        CDOChangeSetData changeSetData = this.getRemoteChangeSetData();
        if (changeSetData == null) {
            return null;
        }
        if (changeSetData instanceof CDOTimeProvider) {
            this.remoteTimeStamp = ((CDOTimeProvider)changeSetData).getTimeStamp();
        }
        return this.createChangeSet(changeSetData);
    }

    public final long getRemoteTimeStamp() {
        return this.remoteTimeStamp;
    }

    @Override
    public void handleNonConflict(long updateTime) {
        this.remoteInvalidationEvents.remove(updateTime);
    }

    @Override
    protected void hookTransaction(CDOTransaction transaction) {
        if (this.ensureRemoteNotifications) {
            this.adapter = new CDOChangeSubscriptionAdapter(this.getTransaction());
            transaction.addTransactionHandler(this.handler);
        }
        this.remoteInvalidationEvents = new RemoteInvalidationEventQueue();
    }

    @Override
    protected void unhookTransaction(CDOTransaction transaction) {
        if (this.ensureRemoteNotifications) {
            transaction.removeTransactionHandler(this.handler);
            if (!transaction.isClosed()) {
                this.adapter.dispose();
            }
            this.adapter = null;
        }
        this.remoteInvalidationEvents.dispose();
        this.remoteInvalidationEvents = null;
    }

    protected void transactionAttachingObject(CDOObject object) {
    }

    protected void transactionDetachingObject(CDOObject object) {
    }

    protected void transactionModifyingObject(CDOObject object, CDOFeatureDelta featureDelta) {
        this.adapter.attach(object);
    }

    protected void transactionCommitting(CDOCommitContext commitContext) {
    }

    protected void transactionCommitted(CDOCommitContext commitContext) {
        this.adapter.reset();
        this.remoteInvalidationEvents.reset();
    }

    protected void transactionRolledBack() {
        this.adapter.reset();
        this.remoteInvalidationEvents.reset();
    }

    private CDOChangeSet createChangeSet(CDOChangeSetData changeSetData) {
        CDOTransaction transaction = this.getTransaction();
        return CDORevisionUtil.createChangeSet((CDOBranchPoint)transaction, (CDOBranchPoint)transaction, (CDOChangeSetData)changeSetData);
    }

    private final class RemoteInvalidationEventQueue
    extends CDOSessionInvalidationEventQueue {
        public RemoteInvalidationEventQueue() {
            super(AbstractChangeSetsConflictResolver.this.getTransaction().getSession());
        }

        @Override
        protected void handleEvent(CDOSessionInvalidationEvent event) throws Exception {
            CDOTransaction transaction = AbstractChangeSetsConflictResolver.this.getTransaction();
            if (event.getLocalTransaction() == transaction) {
                return;
            }
            if (event.getBranch() != transaction.getBranch()) {
                return;
            }
            super.handleEvent(event);
        }
    }
}

