/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.internal.client.LMNamingStrategy;
import org.eclipse.emf.cdo.lm.provider.LMEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.CheckoutAction;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.widgets.BaselineComposite;
import org.eclipse.emf.cdo.lm.util.LMOperations;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewChangeAction
extends LMAction.NewElement<Stream> {
    private ISystemDescriptor systemDescriptor;
    private EList<Baseline> possibleBases;
    private FixedBaseline base;
    private String labelString;
    private Text labelText;
    private boolean checkout = true;
    private Button checkoutButton;
    private String checkoutLabelString;
    private Text checkoutLabelText;

    public NewChangeAction(IWorkbenchPage page, StructuredViewer viewer, Stream stream, FixedBaseline base) {
        super(page, viewer, "New Change" + INTERACTIVE, "Add a new change to stream '" + stream.getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(LMEditPlugin.INSTANCE.getImage("full/obj16/Change")), "Add a new change to stream '" + stream.getName() + "'.", "icons/wizban/NewChange.png", stream);
        this.base = base;
    }

    @Override
    public String getAuthorizableOperationID() {
        return LMOperations.CREATE_CHANGE;
    }

    @Override
    protected void preRun() throws Exception {
        Stream stream = (Stream)this.getContext();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)stream.getSystem());
        this.possibleBases = new BasicEList();
        stream.forEachBaseline(baseline -> {
            if (baseline instanceof FixedBaseline) {
                this.possibleBases.add(baseline);
            }
        });
        this.possibleBases.sort(Baseline.COMPARATOR);
        if (this.base == null && !this.possibleBases.isEmpty()) {
            this.base = (FixedBaseline)this.possibleBases.get(0);
        }
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Base:");
        BaselineComposite baselineComposite = new BaselineComposite(parent, 0, this.possibleBases, this.getContext());
        baselineComposite.setLayoutData(GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        if (this.base != null) {
            baselineComposite.setBaseline((Baseline)this.base);
        }
        baselineComposite.addModifyListener((control, baseline) -> {
            this.base = (FixedBaseline)baseline;
            this.validateDialog();
        });
        if (this.possibleBases.isEmpty()) {
            label.setEnabled(false);
            baselineComposite.setEnabled(false);
        }
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Label:");
        this.labelText = new Text(parent, 2052);
        this.labelText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        this.labelText.addModifyListener(e -> {
            this.labelString = this.labelText.getText();
            if (this.checkout) {
                this.checkoutLabelText.setText(this.getCheckoutLabel());
            }
            this.validateDialog();
        });
        this.labelText.setFocus();
        this.labelText.selectAll();
        new Label(parent, 0);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.checkoutButton = new Button(composite, 32);
        this.checkoutButton.setText("Checkout as:");
        this.checkoutButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).create());
        this.checkoutButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.checkout = this.checkoutButton.getSelection();
            this.checkoutLabelText.setEnabled(this.checkout);
            this.checkoutLabelText.setText(this.checkout ? this.getCheckoutLabel() : "");
            this.validateDialog();
        }));
        this.checkoutLabelText = new Text(composite, 2052);
        this.checkoutLabelText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        this.checkoutLabelText.addModifyListener(e -> {
            this.checkoutLabelString = this.checkoutLabelText.getText();
            this.validateDialog();
        });
        this.checkoutButton.setSelection(this.checkout);
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (!this.possibleBases.isEmpty() && this.base == null) {
            return "A base must be selected.";
        }
        if (StringUtil.isEmpty((String)this.labelString)) {
            return "A label must be entered.";
        }
        if (this.checkout && (this.checkoutLabelString == null || this.checkoutLabelString.isEmpty())) {
            return "A checkout label must be entered.";
        }
        Stream stream = (Stream)this.getContext();
        String moduleName = stream.getModule().getName();
        boolean[] branchExists = new boolean[1];
        this.systemDescriptor.withModuleSession(moduleName, moduleSession -> {
            CDOBranchPoint baseBranchPoint = (this.base == null ? stream.getBranch().getPointRef(System.currentTimeMillis()) : this.base.getBranchPoint()).resolve(moduleSession.getBranchManager());
            String branchName = LMNamingStrategy.getChangeBranchName((String)this.labelString);
            blArray[0] = baseBranchPoint.getBranch().getBranch(branchName) != null;
        });
        if (branchExists[0]) {
            return "A change with the same label already exists.";
        }
        return super.doValidate(dialog);
    }

    @Override
    protected CDOObject newElement(Stream stream, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("", this.checkout ? 2 : 1);
        Change change = this.systemDescriptor.createChange(stream, this.base, this.labelString, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        if (this.checkout) {
            if (change != null) {
                try {
                    CheckoutAction.checkout((Baseline)change, this.checkoutLabelString, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            } else {
                monitor.worked(1);
            }
        }
        monitor.done();
        return change;
    }

    private String getCheckoutLabel() {
        if (StringUtil.isEmpty((String)this.labelString)) {
            return "";
        }
        return "Module " + ((Stream)this.getContext()).getModule().getName() + " - Change " + this.labelString;
    }
}

