/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.util;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;

public class ScriptTargetMapping {
    private final IFile file;
    private final ConnectedTargetData connectedTargetData;
    private final Collection<? extends VmResource> vmResources;

    public ScriptTargetMapping(IFile file, Collection<? extends VmResource> vmResources, ConnectedTargetData connectedTargetData) {
        this.file = file;
        this.vmResources = vmResources;
        this.connectedTargetData = connectedTargetData;
    }

    public IFile getFile() {
        return this.file;
    }

    public Collection<? extends VmResource> getVmResources() {
        return this.vmResources;
    }

    public JavascriptVm getJavascriptVm() {
        return this.connectedTargetData.getJavascriptVm();
    }

    public ConnectedTargetData getConnectedTargetData() {
        return this.connectedTargetData;
    }

    public Script getSingleScript() {
        Collection<? extends VmResource> vmResources = this.getVmResources();
        if (vmResources.size() != 1) {
            throw new RuntimeException("Several resources found");
        }
        VmResource resource = vmResources.iterator().next();
        if (!(resource.getMetadata() instanceof VmResource.ScriptHolder)) {
            throw new RuntimeException("Unsupported type of resource: " + resource.getMetadata());
        }
        VmResource.ScriptHolder scriptHolder = (VmResource.ScriptHolder)resource.getMetadata();
        return scriptHolder.getSingleScript();
    }

    public boolean isVirtualProjectResource() {
        WorkspaceBridge workspaceBridge = this.connectedTargetData.getWorkspaceRelations();
        return workspaceBridge.getVProjectVmResource(this.file) != null;
    }
}

