/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workbench.provider;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.oomph.base.provider.BaseEditPlugin;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;

public final class WorkbenchEditPlugin
extends EMFPlugin {
    public static final WorkbenchEditPlugin INSTANCE = new WorkbenchEditPlugin();
    private static Implementation plugin;

    public WorkbenchEditPlugin() {
        super(new ResourceLocator[]{BaseEditPlugin.INSTANCE, SetupEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static Set<String> getSchemes() {
        TreeSet<String> result = new TreeSet<String>();
        IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        Scheme[] schemeArray = service.getDefinedSchemes();
        int n = schemeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Scheme schemeId = schemeArray[n2];
            result.add(schemeId.getId());
            ++n2;
        }
        return result;
    }

    public static Map<String, String> getContexts() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Context[] contextArray = ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).getDefinedContexts();
        int n = contextArray.length;
        int n2 = 0;
        while (n2 < n) {
            Context context = contextArray[n2];
            String id = context.getId();
            try {
                String name = context.getName();
                result.put(id, name);
            }
            catch (NotDefinedException ex) {
                result.put(id, null);
            }
            ++n2;
        }
        return result;
    }

    public static Map<String, String> getCommands() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command[] commandArray = commandService.getDefinedCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            try {
                result.put(command.getId(), command.getName());
            }
            catch (NotDefinedException ex) {
                result.put(command.getId(), command.getId());
            }
            ++n2;
        }
        return result;
    }

    public static Map<String, String> getCommandParameters(String commandId) {
        ICommandService commandService;
        Command command;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!StringUtil.isEmpty((String)commandId) && (command = (commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand(commandId)) != null) {
            try {
                IParameter[] parameters = command.getParameters();
                if (parameters != null) {
                    IParameter[] iParameterArray = parameters;
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IParameter parameter = iParameterArray[n2];
                        String id = parameter.getId();
                        String name = parameter.getName();
                        result.put(id, name);
                        ++n2;
                    }
                }
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
        return result;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

