/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.nebula.animation.movement.IMovement;

public abstract class AbstractEffect
implements IEffect {
    protected boolean done = false;
    protected IMovement easingFunction;
    protected long length = 0L;
    protected Runnable runnableOnCancel = null;
    protected Runnable runnableOnStop = null;

    public AbstractEffect(long lengthMilli, IMovement movement) {
        this(lengthMilli, movement, null, null);
    }

    public AbstractEffect(long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        this.length = lengthMilli;
        this.easingFunction = movement;
        this.runnableOnCancel = onCancel;
        this.runnableOnStop = onStop;
    }

    public abstract void applyEffect(long var1);

    @Override
    public void cancel() {
        this.done = true;
        this.doCancel();
    }

    protected void doCancel() {
        if (this.runnableOnCancel != null) {
            this.runnableOnCancel.run();
        }
    }

    public void doEffect() {
    }

    @Override
    public void doEffect(long time) {
        long currentTime = time;
        if (currentTime > this.length) {
            currentTime = this.length;
        }
        this.applyEffect(currentTime);
        this.processEnd(currentTime);
    }

    protected void doStop() {
        if (this.runnableOnStop != null) {
            this.runnableOnStop.run();
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public void processEnd(long time) {
        if (this.done) {
            return;
        }
        if (time == this.length) {
            this.done = true;
            this.doStop();
        }
    }
}

