/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.internal.ui.actions.AbstractOpenViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.OpenDurableViewDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.ui.IWorkbenchPage;

public final class OpenDurableViewAction
extends AbstractOpenViewAction {
    private static final String TITLE = Messages.getString("OpenDurableViewAction.0");
    private static final String TOOL_TIP = Messages.getString("OpenDurableViewAction.1");
    private String areaID;

    public OpenDurableViewAction(IWorkbenchPage page, CDOSession session) {
        super(page, TITLE + INTERACTIVE, TOOL_TIP, SharedIcons.getDescriptor((String)"etool16/open_editor.gif"), session);
    }

    protected void preRun() throws Exception {
        OpenDurableViewDialog dialog = new OpenDurableViewDialog(this.getPage());
        if (dialog.open() == 0) {
            this.areaID = dialog.getAreaID();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOSession session = this.getSession();
        CDOView view = null;
        try {
            CDOTransaction transaction = session.openTransaction(this.areaID);
            CDOUtil.configureView((CDOView)transaction);
            view = transaction;
        }
        catch (IllegalStateException ex) {
            view = this.getSession().openView(this.areaID);
        }
        if (view != null) {
            CDOUtil.configureView((CDOView)view);
        }
    }
}

