/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;

public class RemoteSessionNotificationIndication
extends CDOClientIndication {
    public RemoteSessionNotificationIndication(CDOClientProtocol protocol) {
        super(protocol, (short)32);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        int sessionID = in.readXInt();
        String topicID = in.readString();
        byte opcode = in.readByte();
        InternalCDORemoteSessionManager remoteSessionManager = this.getSession().getRemoteSessionManager();
        switch (opcode) {
            case 1: {
                String userID = in.readString();
                remoteSessionManager.handleRemoteSessionOpened(sessionID, userID);
                break;
            }
            case 2: {
                remoteSessionManager.handleRemoteSessionClosed(sessionID);
                break;
            }
            case 3: {
                remoteSessionManager.handleRemoteSessionSubscribed(sessionID, topicID, true);
                break;
            }
            case 4: {
                remoteSessionManager.handleRemoteSessionSubscribed(sessionID, topicID, false);
            }
        }
    }
}

