/*******************************************************************************
 * Copyright (c) 2024 Advantest Europe GmbH and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * Dietrich Travkin (Solunar GmbH) - Initial implementation
 *******************************************************************************/
package org.eclipse.cdt.lsp.services.ast;

import org.eclipse.cdt.lsp.services.ClangdLanguageServer;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Parameter object type for the <em>textDocument/ast</em> request.
 * This class was generated by the <em>org.eclipse.lsp4j.generator</em> bundle
 * using xtend (see {@link org.eclipse.lsp4j.generator.JsonRpcData JsonRpcData} and
 * the <a href="https://github.com/eclipse-lsp4j/lsp4j/blob/main/documentation/jsonrpc.md">documentation</a>).
 *
 * @see {@link ClangdLanguageServer#getAst(AstParams)}
 */
public class AstParams {

	@NonNull
	private TextDocumentIdentifier textDocument;

	@NonNull
	private Range range;

	public AstParams() {
	}

	public AstParams(@NonNull final TextDocumentIdentifier textDocument, @NonNull final Range range) {
		this.textDocument = Preconditions.<TextDocumentIdentifier>checkNotNull(textDocument, "textDocument"); //$NON-NLS-1$
		this.range = Preconditions.<Range>checkNotNull(range, "range"); //$NON-NLS-1$
	}

	@NonNull
	public TextDocumentIdentifier getTextDocument() {
		return this.textDocument;
	}

	public void setTextDocument(@NonNull final TextDocumentIdentifier textDocument) {
		this.textDocument = Preconditions.<TextDocumentIdentifier>checkNotNull(textDocument, "textDocument"); //$NON-NLS-1$
	}

	@NonNull
	public Range getRange() {
		return range;
	}

	public void setRange(@NonNull Range range) {
		this.range = Preconditions.<Range>checkNotNull(range, "range"); //$NON-NLS-1$
	}

	@Override
	public String toString() {
		ToStringBuilder b = new ToStringBuilder(this);
		b.add("textDocument", getTextDocument()); //$NON-NLS-1$
		b.add("range", getRange()); //$NON-NLS-1$
		return b.toString();
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AstParams other = (AstParams) obj;
		if (this.getTextDocument() == null) {
			if (other.getTextDocument() != null)
				return false;
		} else if (!this.getTextDocument().equals(other.getTextDocument()))
			return false;
		if (this.range == null) {
			if (other.range != null)
				return false;
		} else if (!this.range.equals(other.range))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.getTextDocument() == null) ? 0 : this.getTextDocument().hashCode());
		return prime * result + ((this.range == null) ? 0 : this.range.hashCode());
	}
}
