/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.font;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceRegistryInfo;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontDialog;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;
import org.eclipse.wb.internal.swt.support.DisplaySupport;
import org.eclipse.wb.internal.swt.support.FontSupport;

public final class FontPropertyEditor
extends TextDialogPropertyEditor
implements IClipboardSourceProvider {
    public static final PropertyEditor INSTANCE = new FontPropertyEditor();

    private FontPropertyEditor() {
    }

    public static String getInvocationSource(JavaInfo javaInfo, String name, int height, String style) throws Exception {
        String resourceManager = ManagerContainerInfo.getResourceManagerInfo(javaInfo.getRootJava()).getVariableSupport().getName();
        return String.format("%s.create(org.eclipse.jface.resource.FontDescriptor.createFrom(\"%s\", %d, %s))", resourceManager, name, height, style);
    }

    /*
     * WARNING - void declaration
     */
    protected String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            Expression expression = ((GenericProperty)property).getExpression();
            Expression expression2 = expression;
            if (expression2 instanceof MethodInvocation) {
                void invocation;
                MethodInvocation methodInvocation = (MethodInvocation)expression2;
                MethodInvocation cfr_ignored_0 = (MethodInvocation)expression2;
                if (FontPropertyEditor.isJFaceValue((MethodInvocation)invocation)) {
                    return invocation.getName().getIdentifier() + "()";
                }
                if (FontPropertyEditor.isFontRegistryInvocation((MethodInvocation)invocation)) {
                    return FontPropertyEditor.getTextForRegistry(property, (MethodInvocation)invocation);
                }
                if (FontPropertyEditor.isResourceManagerInvocation((Expression)invocation)) {
                    return FontPropertyEditor.getTextForResourceManager((MethodInvocation)invocation);
                }
            }
            if (value == null) {
                value = DisplaySupport.getSystemFont();
            }
            return FontPropertyEditor.getText(value);
        }
        return null;
    }

    private static String getText(Object font) throws Exception {
        return FontPropertyEditor.getText((FontData)FontSupport.getFontData(font));
    }

    private static String getText(FontData fontData) throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append(FontSupport.getFontName(fontData));
        buffer.append(" ");
        buffer.append(FontSupport.getFontSize(fontData));
        String styleText = FontSupport.getFontStyleText(fontData);
        if (styleText.length() != 0) {
            buffer.append(" ");
            buffer.append(styleText);
        }
        return buffer.toString();
    }

    private static boolean isJFaceValue(MethodInvocation invocation) {
        String identifier = invocation.getName().getIdentifier();
        return identifier.startsWith("get") && identifier.endsWith("Font") && AstNodeUtils.isSuccessorOf((Expression)invocation.getExpression(), (String)"org.eclipse.jface.resource.JFaceResources") && invocation.arguments().isEmpty();
    }

    private static boolean isJFaceValue(Expression expression) {
        if (expression instanceof MethodInvocation) {
            return FontPropertyEditor.isJFaceValue((MethodInvocation)expression);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String getClipboardSource(GenericProperty property) throws Exception {
        Object value = property.getValue();
        if (value == Property.UNKNOWN_VALUE) {
            return null;
        }
        FontInfo fontInfo = new FontInfo(null, value, null, false);
        Expression expression = property.getExpression();
        Expression expression2 = expression;
        if (expression2 instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)expression2;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)expression2;
            String identifier = invocation.getName().getIdentifier();
            if (identifier.startsWith("get") && identifier.endsWith("Font") && AstNodeUtils.getFullyQualifiedName((Expression)invocation.getExpression(), (boolean)false).equals("org.eclipse.jface.resource.JFaceResources") && invocation.arguments().isEmpty()) {
                fontInfo = new FontInfo(null, null, "org.eclipse.jface.resource.JFaceResources." + identifier + "()", false);
            }
        }
        return FontPropertyEditor.getSource(property, fontInfo);
    }

    protected void openDialog(Property property) throws Exception {
        FontInfo fontInfo;
        Object[] registryValue;
        GenericProperty genericProperty = (GenericProperty)property;
        FontDialog fontDialog = new FontDialog(DesignerPlugin.getShell(), genericProperty.getJavaInfo());
        Object value = property.getValue();
        if (value == null || value == Property.UNKNOWN_VALUE) {
            value = DisplaySupport.getSystemFont();
        }
        if ((registryValue = FontPropertyEditor.getRegistryValue(property)) == null) {
            fontInfo = new FontInfo(null, value, null, false);
            if (FontPropertyEditor.isJFaceValue(genericProperty.getExpression())) {
                fontInfo.setPageId("JFace");
            }
        } else {
            fontInfo = new FontInfo(null, value, (String)registryValue[3], false);
            fontInfo.setData(registryValue);
            fontInfo.setPageId("FontRegistry");
        }
        fontDialog.setFontInfo(fontInfo);
        if (fontDialog.open() == 0) {
            FontInfo fontInfo2 = fontDialog.getFontInfo();
            String source = FontPropertyEditor.getSource(genericProperty, fontInfo2);
            genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
        fontDialog.disposeFont();
    }

    private static String getSource(GenericProperty property, FontInfo fontInfo) throws Exception {
        Object source;
        if (fontInfo.getSourceCode() != null) {
            source = fontInfo.getSourceCode();
        } else {
            Object prefix;
            Object fontData = FontSupport.getFontData(fontInfo.getFont());
            String suffix = "";
            IPreferenceStore preferences = property.getJavaInfo().getDescription().getToolkit().getPreferences();
            if (preferences.getBoolean("useResourceManager")) {
                String resourceManager = ManagerContainerInfo.getResourceManagerInfo(property.getJavaInfo().getRootJava()).getVariableSupport().getName();
                prefix = resourceManager + ".create(org.eclipse.jface.resource.FontDescriptor.createFrom(";
                suffix = ")";
            } else {
                prefix = "new org.eclipse.swt.graphics.Font(null, ";
            }
            source = (String)prefix + "\"" + FontSupport.getFontName(fontData) + "\", " + FontSupport.getFontSize(fontData) + ", " + FontSupport.getFontStyleSource(fontData) + ")" + suffix;
        }
        return source;
    }

    private static boolean isFontRegistryInvocation(MethodInvocation invocation) {
        return AstNodeUtils.isMethodInvocation((ASTNode)invocation, (String)"org.eclipse.jface.resource.FontRegistry", (String[])new String[]{"get(java.lang.String)", "getBold(java.lang.String)", "getItalic(java.lang.String)"});
    }

    private static String getTextForRegistry(Property property, MethodInvocation invocation) throws Exception {
        Object keyArgument = invocation.arguments().get(0);
        if (keyArgument instanceof QualifiedName) {
            GenericProperty genericProperty = (GenericProperty)property;
            ResourceRegistryInfo registry = RegistryContainerInfo.getRegistry(genericProperty.getJavaInfo().getRootJava(), (ASTNode)invocation.getExpression());
            String registryTitle = registry.getVariableSupport().getTitle();
            QualifiedName keyQualifiedName = (QualifiedName)keyArgument;
            String key = keyQualifiedName.getName().getIdentifier();
            String prefix = "";
            String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
            if (signature.startsWith("getBold")) {
                prefix = "(b)";
            } else if (signature.startsWith("getItalic")) {
                prefix = "(i)";
            }
            return registryTitle + " - " + key + prefix;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] getRegistryValue(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        Expression expression = genericProperty.getExpression();
        Expression expression2 = expression;
        if (expression2 instanceof MethodInvocation) {
            Object keyArgument;
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)expression2;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)expression2;
            String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
            if (FontPropertyEditor.isFontRegistryInvocation((MethodInvocation)invocation) && (keyArgument = invocation.arguments().get(0)) instanceof QualifiedName) {
                ResourceRegistryInfo registryInfo = RegistryContainerInfo.getRegistry(genericProperty.getJavaInfo().getRootJava(), (ASTNode)invocation.getExpression());
                QualifiedName keyQualifiedName = (QualifiedName)keyArgument;
                String keyName = keyQualifiedName.getName().getIdentifier();
                KeyFieldInfo keyFieldInfo = null;
                List<KeyFieldInfo> keyFields = registryInfo.getKeyFields();
                for (KeyFieldInfo info : keyFields) {
                    if (!keyName.equals(info.keyName)) continue;
                    keyFieldInfo = info;
                    break;
                }
                if (keyFieldInfo == null) {
                    return null;
                }
                int selectionIndex = 0;
                Object methodName = "get";
                if (signature.startsWith("getBold")) {
                    selectionIndex = 1;
                    methodName = (String)methodName + "Bold";
                } else if (signature.startsWith("getItalic")) {
                    selectionIndex = 2;
                    methodName = (String)methodName + "Italic";
                }
                String source = TemplateUtils.format((String)"{0}.{1}({2}.{3})", (Object[])new Object[]{registryInfo, methodName, registryInfo.getDescription().getComponentClass().getName(), keyQualifiedName.getName().getIdentifier()});
                return new Object[]{registryInfo, keyFieldInfo, selectionIndex, source};
            }
        }
        return null;
    }

    private static boolean isResourceManagerInvocation(Expression expression) {
        return AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.jface.resource.ResourceManager", (String)"create(org.eclipse.jface.resource.DeviceResourceDescriptor)");
    }

    private static String getTextForResourceManager(MethodInvocation methodInvocation) throws Exception {
        Expression managerExpression = (Expression)DomGenerics.arguments((MethodInvocation)methodInvocation).get(0);
        if (AstNodeUtils.isMethodInvocation((ASTNode)managerExpression, (String)"org.eclipse.jface.resource.FontDescriptor", (String)"createFrom(java.lang.String,int,int)")) {
            MethodInvocation invocation = (MethodInvocation)managerExpression;
            String name = (String)JavaInfoEvaluationHelper.getValue((Expression)((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0)));
            int height = (Integer)JavaInfoEvaluationHelper.getValue((Expression)((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
            int style = (Integer)JavaInfoEvaluationHelper.getValue((Expression)((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(2)));
            return FontPropertyEditor.getText(new FontData(name, height, style));
        }
        return null;
    }
}

