/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.Logger;

public class PHPCompletionProposalSorter
implements ICompletionProposalSorter {
    public int compare(ICompletionProposal p1, ICompletionProposal p2) {
        if (p1 instanceof AbstractScriptCompletionProposal && p2 instanceof AbstractScriptCompletionProposal) {
            AbstractScriptCompletionProposal cp1 = (AbstractScriptCompletionProposal)p1;
            AbstractScriptCompletionProposal cp2 = (AbstractScriptCompletionProposal)p2;
            IModelElement el1 = cp1.getModelElement();
            IModelElement el2 = cp2.getModelElement();
            if (el1.getElementType() == 7 && el2.getElementType() == 7) {
                try {
                    int result = Boolean.compare(PHPFlags.isNamespace((int)((IType)el1).getFlags()), PHPFlags.isNamespace((int)((IType)el2).getFlags()));
                    if (result != 0) {
                        return result;
                    }
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
            if (el1.getElementName().equals(el2.getElementName())) {
                String parent1 = this.getParentQualifier(el1.getParent());
                String parent2 = this.getParentQualifier(el2.getParent());
                if (parent1 == null && parent2 == null) {
                    return 0;
                }
                if (parent1 == null) {
                    return -1;
                }
                if (parent2 == null) {
                    return 1;
                }
                int segments1 = StringUtils.countMatches((CharSequence)parent1, (CharSequence)"\\");
                int segments2 = StringUtils.countMatches((CharSequence)parent2, (CharSequence)"\\");
                if (segments1 == 0 || segments2 == 0) {
                    return Integer.compare(segments1, segments2);
                }
                return parent1.compareToIgnoreCase(parent2);
            }
            return 0;
        }
        return 0;
    }

    private String getParentQualifier(IModelElement parent) {
        if (parent instanceof IType) {
            IType type = (IType)parent;
            return type.getTypeQualifiedName("\\");
        }
        return null;
    }
}

