/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetLocationFactory;
import org.eclipse.m2e.pde.ui.target.editor.MavenTargetLocationWizard;
import org.eclipse.m2e.pde.ui.target.editor.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClipboardParser {
    private Exception error;
    private List<MavenTargetDependency> dependencies = new ArrayList<MavenTargetDependency>();

    public ClipboardParser(String text) {
        if (text != null && text.trim().startsWith("<")) {
            text = "<dummy>" + text + "</dummy>";
            try {
                Document doc = MavenTargetLocationFactory.parseXMLDocument((String)text);
                NodeList dependencies = doc.getElementsByTagName("dependency");
                MavenTargetLocationFactory.elements((NodeList)dependencies).forEach(this::parseElement);
                if (this.dependencies.isEmpty()) {
                    this.parseElement(doc.getDocumentElement());
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }

    private void parseElement(Element element) {
        String groupId = this.getTextFor("groupId", element, "");
        String artifactId = this.getTextFor("artifactId", element, "");
        String version = this.getTextFor("version", element, "");
        String classifier = this.getTextFor("classifier", element, "");
        String type = this.getTextFor("type", element, "jar");
        this.dependencies.add(new MavenTargetDependency(groupId, artifactId, version, type, classifier));
    }

    private String getTextFor(String element, Element doc, String defaultValue) {
        String v;
        NodeList nl = doc.getElementsByTagName(element);
        Node item = nl.item(0);
        if (item != null && (v = item.getTextContent()) != null && !v.isBlank()) {
            return v;
        }
        return defaultValue;
    }

    public Exception getError() {
        return this.error;
    }

    public List<MavenTargetDependency> getDependencies() {
        return this.dependencies;
    }

    public static List<MavenTargetDependency> getClipboardDependencies(Display display) {
        List<MavenTargetDependency> list;
        block3: {
            Exception clipboardError;
            String text = ClipboardParser.getClipboardContent(display);
            ClipboardParser clipboardParser = new ClipboardParser(text);
            try {
                list = clipboardParser.getDependencies();
                clipboardError = clipboardParser.getError();
                if (clipboardError == null) break block3;
            }
            catch (Throwable throwable) {
                Exception clipboardError2 = clipboardParser.getError();
                if (clipboardError2 != null) {
                    Platform.getLog(MavenTargetLocationWizard.class).warn(MessageFormat.format(Messages.ClipboardParser_1, clipboardError2.getMessage()));
                }
                throw throwable;
            }
            Platform.getLog(MavenTargetLocationWizard.class).warn(MessageFormat.format(Messages.ClipboardParser_1, clipboardError.getMessage()));
        }
        return list;
    }

    private static String getClipboardContent(Display display) {
        Clipboard clipboard = new Clipboard(display);
        try {
            String string = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            return string;
        }
        finally {
            clipboard.dispose();
        }
    }
}

