/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.diagram;

import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.examples.chess.features.AddChessBoardFeature;
import org.eclipse.graphiti.examples.chess.features.AddChessMoveFeature;
import org.eclipse.graphiti.examples.chess.features.AddChessPieceFeature;
import org.eclipse.graphiti.examples.chess.features.CreateAllInitialChessPiecesFeature;
import org.eclipse.graphiti.examples.chess.features.CreateChessBoardFeature;
import org.eclipse.graphiti.examples.chess.features.CreateChessMoveFeature;
import org.eclipse.graphiti.examples.chess.features.MoveChessPieceFeature;
import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;

public class ChessFeatureProvider
extends DefaultFeatureProvider {
    private boolean programmaticFeatureCallActive = false;

    public ChessFeatureProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public boolean isProgrammaticFeatureCallActive() {
        return this.programmaticFeatureCallActive;
    }

    public void setProgrammaticFeatureCallActive(boolean programmaticFeatureCallActive) {
        this.programmaticFeatureCallActive = programmaticFeatureCallActive;
    }

    public ICreateFeature[] getCreateFeatures() {
        return new ICreateFeature[]{new CreateChessBoardFeature((IFeatureProvider)this), new CreateAllInitialChessPiecesFeature((IFeatureProvider)this)};
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new CreateChessMoveFeature((IFeatureProvider)this)};
    }

    public IAddFeature getAddFeature(IAddContext context) {
        Object newObject = context.getNewObject();
        if (newObject instanceof Board) {
            return new AddChessBoardFeature((IFeatureProvider)this);
        }
        if (newObject instanceof Piece) {
            return new AddChessPieceFeature((IFeatureProvider)this);
        }
        if (newObject == null && context.getProperty((Object)"move") == Boolean.TRUE) {
            return new AddChessMoveFeature((IFeatureProvider)this);
        }
        return super.getAddFeature(context);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (bo instanceof Board) {
            return null;
        }
        if (bo instanceof Square) {
            return null;
        }
        if (bo instanceof Piece && !this.programmaticFeatureCallActive) {
            return null;
        }
        return super.getRemoveFeature(context);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (bo instanceof Board) {
            return null;
        }
        if (bo instanceof Square) {
            return null;
        }
        if (bo instanceof Piece && !this.programmaticFeatureCallActive) {
            return null;
        }
        return super.getDeleteFeature(context);
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (bo instanceof Board) {
            return null;
        }
        if (bo instanceof Square) {
            return null;
        }
        if (bo instanceof Piece) {
            return null;
        }
        return super.getResizeShapeFeature(context);
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        if (bo instanceof Square) {
            return null;
        }
        if (bo instanceof Piece) {
            return new MoveChessPieceFeature((IFeatureProvider)this);
        }
        return super.getMoveShapeFeature(context);
    }

    public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
        return null;
    }

    public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
        return null;
    }

    public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
        return null;
    }
}

