/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import com.google.common.collect.Maps;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultJavaInfoPresentation;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.utils.ui.ImageDisposer;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.osgi.framework.Bundle;

public abstract class StylePresentation
extends DefaultJavaInfoPresentation {
    private static final ClassMap<Map<Integer, Image>> m_images = ClassMap.create();

    public StylePresentation(WidgetInfo widget) {
        super((JavaInfo)widget);
    }

    public Image getIcon() throws Exception {
        int style = ControlSupport.getStyle(this.m_javaInfo.getObject());
        for (Map.Entry<Integer, Image> entry : this.getImages().entrySet()) {
            int keyStyle = entry.getKey();
            if ((style & keyStyle) != keyStyle) continue;
            return entry.getValue();
        }
        return super.getIcon();
    }

    protected abstract void initImages() throws Exception;

    private Map<Integer, Image> getImages() throws Exception {
        Map images = (Map)m_images.get(((Object)((Object)this)).getClass());
        if (images == null) {
            images = Maps.newHashMap();
            m_images.put(((Object)((Object)this)).getClass(), (Object)images);
            this.initImages();
        }
        return images;
    }

    protected final void addImage(int style, String imagePath) throws Exception {
        Bundle bundle = this.m_javaInfo.getDescription().getToolkit().getBundle();
        URL imageURL = bundle.getEntry(imagePath);
        Assert.isNotNull((Object)imageURL, (String)MessageFormat.format(ModelMessages.StylePresentation_canNotFindImage, imagePath, bundle.getSymbolicName()));
        Image image = new Image((Device)Display.getDefault(), imageURL.openStream());
        this.getImages().put(style, image);
        ImageDisposer.add(((Object)((Object)this)).getClass(), (String)imagePath, (Image)image);
    }
}

