/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.AbstractMarkupDocumentBuilder;

public class AsciiDocDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();

    public AsciiDocDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("amp", "&");
        this.entityToLiteral.put("lt", "<");
        this.entityToLiteral.put("gt", ">");
        this.entityToLiteral.put("copy", "(C)");
        this.currentBlock = null;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case PARAGRAPH: {
                return new ContentBlock(type, "", "", 2, 2);
            }
            case QUOTE: {
                return new ContentBlock(type, "[quote]\n----\n", "\n----\n", 1, 1);
            }
            case BULLETED_LIST: 
            case DEFINITION_LIST: 
            case NUMERIC_LIST: {
                DocumentBuilder.BlockType currentBlockType;
                if (this.currentBlock != null && ((currentBlockType = this.currentBlock.getBlockType()) == DocumentBuilder.BlockType.LIST_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_TERM)) {
                    return new ListBlock(type, 1);
                }
                return new ListBlock(type, 2);
            }
            case LIST_ITEM: {
                if (this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST) {
                    return new ListItemBlock("1. ");
                }
                return new ListItemBlock("* ");
            }
            case CODE: 
            case PREFORMATTED: {
                return new ContentBlock(type, "[listing]\n----\n", "\n----", 1, 2);
            }
            case TABLE: {
                return new ContentBlock(type, "|===\n", "|===", 1, 1);
            }
            case TABLE_ROW: {
                return new ContentBlock(type, "", "", 2, 1);
            }
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: {
                return new ContentBlock(type, "|", " ", 0, 0);
            }
            case DIV: {
                return new ContentBlock(type, "", "", 0, 0);
            }
            case DEFINITION_ITEM: {
                return new ContentBlock(type, ":: ", "", 0, 1);
            }
            case DEFINITION_TERM: {
                return new ContentBlock(type, "", "", 0, 0);
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "", 2, 2);
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        switch (type) {
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    return new LinkBlock((LinkAttributes)attributes);
                }
                return new ContentBlock("", "", 0, 0);
            }
            case ITALIC: 
            case EMPHASIS: {
                return new ContentBlock("_", "_", 0, 0);
            }
            case BOLD: 
            case STRONG: {
                return new ContentBlock("*", "*", 0, 0);
            }
            case CODE: {
                return new CodeSpan();
            }
            case SUPERSCRIPT: {
                return new ContentBlock("^", "^", 0, 0);
            }
            case SUBSCRIPT: {
                return new ContentBlock("~", "~", 0, 0);
            }
            case MARK: {
                return new ContentBlock("#", "#", 0, 0);
            }
            case SPAN: {
                if (attributes.getCssClass() != null) {
                    return new ContentBlock("[" + attributes.getCssClass() + "]#", "#", 0, 0);
                }
                return new ContentBlock("", "", 0, 0);
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock("", "", 0, 0);
    }

    protected AbstractMarkupDocumentBuilder.Block computeHeading(int level, Attributes attributes) {
        return new ContentBlock(this.computePrefix('=', level) + " ", "", 2, 2);
    }

    public void characters(String text) {
        if (text != null) {
            text = this.escapeAmpersand(text);
            this.assertOpenBlock();
            try {
                this.currentBlock.write(text);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String escapeAmpersand(String text) {
        return text.replace("&", "&amp;");
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        Object literal = this.entityToLiteral.get(entity);
        if (literal == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write((String)literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(this.computeImage(attributes, url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String computeImage(Attributes attributes, String url) {
        String altText = null;
        String title = null;
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttr = (ImageAttributes)attributes;
            altText = imageAttr.getAlt();
        }
        if (!Strings.isNullOrEmpty((String)attributes.getTitle())) {
            title = "title=\"" + attributes.getTitle() + "\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("image:");
        sb.append(Strings.nullToEmpty((String)url));
        sb.append("[");
        sb.append(Arrays.asList(altText, title).stream().filter(Objects::nonNull).collect(Collectors.joining(", ")));
        sb.append("]");
        return sb.toString();
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        LinkAttributes linkAttr = new LinkAttributes();
        linkAttr.setTitle(attributes.getTitle());
        linkAttr.setHref(hrefOrHashName);
        this.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)linkAttr);
        if (Strings.isNullOrEmpty((String)text)) {
            this.characters(hrefOrHashName);
        } else {
            this.characters(text);
        }
        this.endSpan();
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.link(linkAttributes, href, this.computeImage(imageAttributes, imageUrl));
    }

    public void acronym(String text, String definition) {
        this.assertOpenBlock();
        this.characters(text);
        this.characters("(");
        this.characters(definition);
        this.characters(")");
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof AsciiDocBlock) {
                ((AsciiDocBlock)this.currentBlock).lineBreak();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.NewlineDelimitedBlock
    implements AsciiDocBlock {
        protected String prefix;
        protected String suffix;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, int leadingNewlines, int trailingNewlines) {
            super((AbstractMarkupDocumentBuilder)AsciiDocDocumentBuilder.this, blockType, leadingNewlines, trailingNewlines);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        ContentBlock(String prefix, String suffix, int leadingNewlines, int trailingNewlines) {
            this(null, prefix, suffix, leadingNewlines, trailingNewlines);
        }

        public void write(int c) throws IOException {
            AsciiDocDocumentBuilder.this.emitContent(c);
        }

        public void write(String s) throws IOException {
            AsciiDocDocumentBuilder.this.emitContent(s);
        }

        @Override
        public void lineBreak() throws IOException {
            this.write("\n");
        }

        public void open() throws IOException {
            super.open();
            AsciiDocDocumentBuilder.this.pushWriter(new StringWriter());
        }

        public void close() throws IOException {
            Writer thisContent = AsciiDocDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            if (content.length() > 0) {
                this.emitContent(content);
            }
            super.close();
        }

        protected void emitContent(String content) throws IOException {
            AsciiDocDocumentBuilder.this.emitContent(this.prefix);
            AsciiDocDocumentBuilder.this.emitContent(content);
            AsciiDocDocumentBuilder.this.emitContent(this.suffix);
        }
    }

    private class ListBlock
    extends ContentBlock {
        private int count;

        ListBlock(DocumentBuilder.BlockType blockType, int leadingNewlines) {
            super(blockType, "", "", leadingNewlines, 1);
            this.count = 0;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            AsciiDocDocumentBuilder.this.emitContent(this.prefix);
            AsciiDocDocumentBuilder.this.emitContent(content);
            if (!content.endsWith("\n\n")) {
                AsciiDocDocumentBuilder.this.emitContent(this.suffix);
            }
        }

        protected void addListItem(ListItemBlock item) {
            Objects.requireNonNull(item);
            ++this.count;
        }

        protected int getCount() {
            return this.count;
        }
    }

    private class ListItemBlock
    extends ContentBlock {
        private int count;

        private ListItemBlock(String prefix) {
            super(DocumentBuilder.BlockType.LIST_ITEM, prefix, "", 1, 1);
        }

        @Override
        public void open() throws IOException {
            super.open();
            if (this.getPreviousBlock() instanceof ListBlock) {
                ListBlock list = (ListBlock)this.getPreviousBlock();
                list.addListItem(this);
                this.count = list.getCount();
            }
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (this.getPreviousBlock().getBlockType() == DocumentBuilder.BlockType.NUMERIC_LIST) {
                this.prefix = this.count + ". ";
            }
            super.emitContent(content);
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        LinkBlock(LinkAttributes attributes) {
            super("", "", 0, 0);
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            AsciiDocDocumentBuilder.this.emitContent("link:");
            AsciiDocDocumentBuilder.this.emitContent(this.attributes.getHref());
            AsciiDocDocumentBuilder.this.emitContent(91);
            if (content != null) {
                AsciiDocDocumentBuilder.this.emitContent(content);
            }
            AsciiDocDocumentBuilder.this.emitContent(93);
        }
    }

    private class CodeSpan
    extends ContentBlock {
        private CodeSpan() {
            super("`", "`", 0, 0);
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (content.contains("`")) {
                this.prefix = "`` ";
                this.suffix = " ``";
            }
            super.emitContent(content);
        }
    }

    private static interface AsciiDocBlock {
        public void lineBreak() throws IOException;
    }

    private class ImplicitParagraphBlock
    extends ContentBlock {
        ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, "", "", 2, 2);
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }
}

