/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.gateways;

import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeColumnProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeContentProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.ui.property.gateways.Messages;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class GatewayDetailComposite
extends DefaultDetailComposite {
    protected SequenceFlowsListComposite sequenceFlowsList;

    public GatewayDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public GatewayDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public AbstractPropertiesProvider getPropertiesProvider(EObject object) {
        if (this.propertiesProvider == null) {
            this.propertiesProvider = new AbstractPropertiesProvider(object){
                String[] properties;
                {
                    this.properties = new String[]{"gatewayDirection", "instantiate", "activationCondition", "eventGatewayType", "outgoing"};
                }

                public String[] getProperties() {
                    return this.properties;
                }
            };
        }
        return this.propertiesProvider;
    }

    public void cleanBindings() {
        super.cleanBindings();
        this.sequenceFlowsList = null;
    }

    public void createBindings(EObject be) {
        super.createBindings(be);
        Gateway gateway = (Gateway)be;
        if (!(gateway instanceof ParallelGateway)) {
            this.sequenceFlowsList = this.createSequenceFlowsListComposite((Composite)this);
            this.sequenceFlowsList.bindList((EObject)gateway, (EStructuralFeature)Bpmn2Package.eINSTANCE.getFlowNode_Outgoing());
        }
    }

    protected void bindReference(Composite parent, EObject object, EReference reference) {
        if (!reference.getName().equals("outgoing")) {
            super.bindReference(parent, object, reference);
        }
    }

    protected SequenceFlowsListComposite createSequenceFlowsListComposite(Composite parent) {
        return new SequenceFlowsListComposite(parent);
    }

    public class SequenceFlowListColumn
    extends TableColumn {
        int columnIndex;

        public SequenceFlowListColumn(EObject gateway, int columnIndex) {
            super(gateway, null);
            this.columnIndex = columnIndex;
        }

        public String getHeaderText() {
            switch (this.columnIndex) {
                case 1: {
                    return Messages.GatewayDetailComposite_Sequence_Flow_Header;
                }
                case 2: {
                    return Messages.GatewayDetailComposite_Condition_Header;
                }
                case 3: {
                    return Messages.GatewayDetailComposite_Is_Default_Header;
                }
            }
            return "header " + this.columnIndex;
        }

        public String getText(Object element) {
            SequenceFlow flow = (SequenceFlow)element;
            Gateway gateway = (Gateway)this.object;
            String text = "";
            switch (this.columnIndex) {
                case 1: {
                    text = flow.getName();
                    if (text != null && !text.isEmpty()) break;
                    text = ExtendedPropertiesProvider.getTextValue((EObject)flow.getSourceRef());
                    text = String.valueOf(text) + " -> ";
                    text = String.valueOf(text) + ExtendedPropertiesProvider.getTextValue((EObject)flow.getTargetRef());
                    break;
                }
                case 2: {
                    text = ExtendedPropertiesProvider.getTextValue((EObject)flow.getConditionExpression());
                    if (text != null) break;
                    text = "";
                    break;
                }
                case 3: {
                    EStructuralFeature f = gateway.eClass().getEStructuralFeature("default");
                    Object defaultFlow = gateway.eGet(f);
                    text = String.valueOf(text) + (flow == defaultFlow);
                }
            }
            return text;
        }

        public Object getValue(Object element, String property) {
            return null;
        }

        public String getProperty() {
            return "column " + this.columnIndex;
        }
    }

    public class SequenceFlowListColumnProvider
    extends ListCompositeColumnProvider {
        public SequenceFlowListColumnProvider(AbstractListComposite list, EObject object) {
            this(list, false);
            this.add(gatewayDetailComposite.new SequenceFlowListColumn(object, 1));
            this.add(gatewayDetailComposite.new SequenceFlowListColumn(object, 2));
            if (object.eClass().getEStructuralFeature("default") != null) {
                this.add(gatewayDetailComposite.new SequenceFlowListColumn(object, 3));
            }
        }

        public SequenceFlowListColumnProvider(AbstractListComposite list, boolean canModify) {
            super(list, canModify);
        }
    }

    public class SequenceFlowsListComposite
    extends DefaultListComposite {
        public SequenceFlowsListComposite(AbstractBpmn2PropertySection section) {
            super(section, 0x1800000);
        }

        public SequenceFlowsListComposite(Composite parent) {
            super(parent, 0x1800000);
        }

        public ListCompositeContentProvider getContentProvider(EObject object, EStructuralFeature feature, EList<EObject> list) {
            if (this.contentProvider == null) {
                this.contentProvider = new SequenceFlowsListContentProvider((AbstractListComposite)this, object);
            }
            return this.contentProvider;
        }

        public ListCompositeColumnProvider getColumnProvider(EObject object, EStructuralFeature feature) {
            if (this.columnProvider == null) {
                this.columnProvider = new SequenceFlowListColumnProvider((AbstractListComposite)this, object);
            }
            return this.columnProvider;
        }

        public void bindList(EObject theobject, EStructuralFeature thefeature) {
            super.bindList(theobject, thefeature);
            if (this.tableViewer != null) {
                this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        StructuredSelection sel = (StructuredSelection)event.getSelection();
                        EObject object = (EObject)sel.getFirstElement();
                        Diagram diagram = SequenceFlowsListComposite.this.getDiagramEditor().getDiagramTypeProvider().getDiagram();
                        List pes = Graphiti.getLinkService().getPictogramElements(diagram, object);
                        if (!pes.isEmpty()) {
                            SequenceFlowsListComposite.this.getDiagramEditor().setPictogramElementForSelection((PictogramElement)pes.get(0));
                        }
                        SequenceFlowsListComposite.this.getDiagramEditor().getDiagramBehavior().getRefreshBehavior().refresh();
                    }
                });
            }
        }
    }

    public class SequenceFlowsListContentProvider
    extends ListCompositeContentProvider {
        public SequenceFlowsListContentProvider(AbstractListComposite listComposite, EObject object) {
            super(listComposite, object, null, null);
            Gateway gateway = (Gateway)object;
            this.list = new BasicEList();
            this.list.addAll((Collection)gateway.getOutgoing());
        }

        public Object[] getElements(Object inputElement) {
            return this.list.toArray();
        }
    }
}

