/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.project.facet;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.web.internal.WSTWebPlugin;

public class SimpleWebFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)config;
            this.addNatures(project);
            IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
            c.create(0, null);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IPath pjpath = project.getFullPath();
            IPath contentdir = this.setContentPropertyIfNeeded(model, pjpath, project);
            SimpleWebFacetInstallDelegate.mkdirs(ws.getRoot().getFolder(contentdir));
            IVirtualFolder webroot = c.getRootFolder();
            if (webroot.getProjectRelativePath().equals((Object)new Path("/"))) {
                webroot.createLink((IPath)new Path("/" + model.getStringProperty("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR")), 0, null);
            }
            ComponentUtilities.setServerContextRoot((IProject)project, (String)model.getStringProperty("IStaticWebFacetInstallDataModelProperties.CONTEXT_ROOT"));
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                WSTWebPlugin.logError(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private IPath setContentPropertyIfNeeded(IDataModel model, IPath pjpath, IProject project) {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        if (c.exists() && !c.getRootFolder().getProjectRelativePath().isRoot()) {
            return c.getRootFolder().getUnderlyingResource().getFullPath();
        }
        return pjpath.append(model.getStringProperty("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR"));
    }

    private void addNatures(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] current = desc.getNatureIds();
        String[] replacement = new String[current.length + 1];
        System.arraycopy(current, 0, replacement, 0, current.length);
        replacement[current.length] = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
        desc.setNatureIds(replacement);
        project.setDescription(desc, null);
    }

    private static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                SimpleWebFacetInstallDelegate.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }
}

