/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui.history;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.ui.TestRunnerViewPart;
import org.eclipse.unittest.internal.ui.history.HistoryDialog;
import org.eclipse.unittest.internal.ui.history.HistoryItem;

public class HistoryHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.unittest.ui.history";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPage page = HandlerUtil.getActivePart((ExecutionEvent)event).getSite().getPage();
        Set<TestRunSession> visibleSessions = Arrays.stream(page.getViewReferences()).map(ref -> ref.getPart(false)).filter(TestRunnerViewPart.class::isInstance).map(TestRunnerViewPart.class::cast).map(TestRunnerViewPart::getCurrentTestRunSession).filter(Objects::nonNull).collect(Collectors.toSet());
        HistoryDialog historyDialog = new HistoryDialog(shell, visibleSessions);
        historyDialog.setBlockOnOpen(true);
        if (historyDialog.open() == 0) {
            HistoryItem item = (HistoryItem)historyDialog.getResult()[0];
            try {
                TestRunnerViewPart part = this.findCurrentPartOrOpenNew(HandlerUtil.getActivePart((ExecutionEvent)event));
                part.setActiveTestRunSession(item.reloadTestRunSession());
            }
            catch (CoreException e) {
                UnitTestPlugin.log(e);
            }
        }
        return null;
    }

    private TestRunnerViewPart findCurrentPartOrOpenNew(IWorkbenchPart part) throws PartInitException {
        if (part instanceof TestRunnerViewPart) {
            return (TestRunnerViewPart)part;
        }
        return (TestRunnerViewPart)part.getSite().getPage().showView("org.eclipse.unittest.ui.ResultView");
    }
}

