/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.launcher.TestViewSupportRegistry;
import org.eclipse.unittest.internal.model.ITestRunSessionReport;
import org.eclipse.unittest.internal.model.ITestSessionListener;
import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.internal.model.Status;
import org.eclipse.unittest.internal.model.TestCaseElement;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestRunListenerAdapter;
import org.eclipse.unittest.internal.model.TestSuiteElement;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;
import org.eclipse.unittest.ui.ITestViewSupport;

public class TestRunSession
extends TestSuiteElement
implements ITestRunSession,
ITestRunSessionReport {
    private final ILaunch fLaunch;
    private final String fTestRunName;
    private final ITestViewSupport fTestRunnerSupport;
    private ITestRunnerClient fTestRunnerClient;
    private final ListenerList<ITestSessionListener> fSessionListeners;
    private final TestSessionNotifier fSessionNotifier = new TestSessionNotifier();
    private ITestElement.Result fTestResult;
    private HashMap<String, TestElement> fIdToTest;
    volatile Instant fStartTime;
    volatile Integer fPredefinedTestCount;
    volatile boolean fIsAborted;
    private Integer predefinedTestCount;
    private boolean completedOrAborted;

    public TestRunSession(String testRunName, Instant startTime, ILaunchConfiguration launchConfiguration) {
        super(null, "-1", testRunName, null, null, null);
        this.fLaunch = new NoopLaunch(launchConfiguration, "run", null);
        this.fTestRunnerSupport = TestViewSupportRegistry.newTestRunnerViewSupport(launchConfiguration).orElse(null);
        Assert.isNotNull((Object)testRunName);
        this.fTestRunName = testRunName;
        this.fIdToTest = new HashMap();
        this.fTestRunnerClient = null;
        this.fStartTime = startTime;
        this.fSessionListeners = new ListenerList();
    }

    public TestRunSession(ILaunch launch) {
        super(null, "-1", "<TestRunSession>", null, null, null);
        Assert.isNotNull((Object)launch);
        this.fLaunch = launch;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration != null) {
            this.fTestRunName = launchConfiguration.getName();
            this.fTestRunnerSupport = TestViewSupportRegistry.newTestRunnerViewSupport(launchConfiguration).orElse(null);
        } else {
            this.fTestRunName = "<TestRunSession>";
            this.fTestRunnerSupport = null;
        }
        this.fIdToTest = new HashMap();
        if (this.fTestRunnerSupport != null) {
            this.fTestRunnerClient = this.fTestRunnerSupport.newTestRunnerClient(this);
        }
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                if (Arrays.asList(launches).contains(TestRunSession.this.fLaunch)) {
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                }
            }

            public void launchesRemoved(ILaunch[] launches) {
                if (Arrays.asList(launches).contains(TestRunSession.this.fLaunch)) {
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                }
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }
        });
        this.fSessionListeners = new ListenerList();
        this.setStatus(Status.RUNNING);
        this.addTestSessionListener(new TestRunListenerAdapter(this));
        this.fTestRunnerClient.startMonitoring();
    }

    public void reset() {
        this.fTestResult = null;
        this.fIdToTest = new HashMap();
    }

    @Override
    public ProgressState getProgressState() {
        if (this.isRunning()) {
            return ProgressState.RUNNING;
        }
        if (this.isStopped()) {
            return ProgressState.ABORTED;
        }
        return ProgressState.COMPLETED;
    }

    @Override
    public ITestElement.FailureTrace getFailureTrace() {
        return null;
    }

    @Override
    public TestSuiteElement getParentContainer() {
        return null;
    }

    @Override
    public TestRunSession getTestRunSession() {
        return this;
    }

    public ITestViewSupport getTestViewSupport() {
        return this.fTestRunnerSupport;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    @Override
    public String getTestRunName() {
        return this.fTestRunName;
    }

    @Override
    public int getCurrentErrorCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentErrorCount).sum();
    }

    @Override
    public int getCurrentFailureCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentFailureCount).sum();
    }

    @Override
    public int getCurrentAssumptionFailureCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentAssumptionFailureCount).sum();
    }

    @Override
    public int getCurrentIgnoredCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentIgnoredCount).sum();
    }

    public Instant getStartTime() {
        return this.fStartTime;
    }

    @Override
    public boolean isStopped() {
        return this.fIsAborted;
    }

    public synchronized void addTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.add((Object)listener);
    }

    public void removeTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.remove((Object)listener);
    }

    @Override
    public boolean isStarting() {
        return this.getStartTime() == null && this.fLaunch != null && !this.fLaunch.isTerminated();
    }

    public void abortTestRun() {
        this.fIsAborted = true;
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
            this.fTestRunnerClient.stopMonitoring();
        }
    }

    @Override
    public boolean isRunning() {
        return this.getStartTime() != null && this.fTestRunnerClient != null && !this.completedOrAborted;
    }

    @Override
    public TestElement getTestElement(String id) {
        return this.fIdToTest.get(id);
    }

    private TestElement addTreeEntry(String id, String testName, boolean isSuite, Integer testCount, boolean isDynamicTest, TestSuiteElement parent, String displayName, String data) {
        return this.createTestElement(parent != null ? parent : this, id, testName, isSuite, testCount, isDynamicTest, displayName, data);
    }

    public TestElement createTestElement(TestSuiteElement parent, String id, String testName, boolean isSuite, Integer testCount, boolean isDynamicTest, String displayName, String data) {
        TestElement testElement;
        if (isSuite) {
            TestSuiteElement testSuiteElement = new TestSuiteElement(parent != null ? parent : this, id, testName, testCount, displayName, data);
            testElement = testSuiteElement;
        } else {
            testElement = new TestCaseElement(parent != null ? parent : this, id, testName, displayName, isDynamicTest, data);
        }
        this.fIdToTest.put(id, testElement);
        return testElement;
    }

    public void registerTestFailureStatus(TestElement testElement, ITestElement.Result status, ITestElement.FailureTrace failureTrace) {
        testElement.setStatus(Status.fromResult(status), failureTrace);
    }

    public void registerTestEnded(TestElement testElement, boolean completed) {
        if (testElement instanceof TestCaseElement) {
            if (!completed) {
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            if (!testCaseElement.getStatus().isErrorOrFailure()) {
                this.setStatus(testElement, Status.OK);
            }
        }
    }

    private void setStatus(ITestElement testElement, Status status) {
        ((TestElement)testElement).setStatus(status);
    }

    public List<TestElement> getAllFailedTestElements() {
        ArrayList<TestElement> failures = new ArrayList<TestElement>();
        this.addFailures(failures, this);
        return Collections.unmodifiableList(failures);
    }

    private void addFailures(Collection<TestElement> failures, TestElement testElement) {
        ITestElement.Result testResult = testElement.getTestResult(true);
        if (testResult == ITestElement.Result.ERROR || testResult == ITestElement.Result.FAILURE) {
            failures.add(testElement);
        }
        if (testElement instanceof TestSuiteElement) {
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            for (TestElement child : testSuiteElement.getChildren()) {
                this.addFailures(failures, child);
            }
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.fTestRunName) + " " + DateFormat.getDateTimeInstance().format(new Date(this.fStartTime.toEpochMilli()));
    }

    @Override
    public TestSuiteElement getParent() {
        return null;
    }

    @Override
    public String getTestName() {
        return this.getTestRunName();
    }

    @Override
    public TestCaseElement newTestCase(String testId, String testName, ITestSuiteElement parent, String displayName, String data) {
        return (TestCaseElement)this.fSessionNotifier.testTreeEntry(testId, testName, false, 1, false, parent, displayName, data);
    }

    @Override
    public TestSuiteElement newTestSuite(String testId, String testName, Integer testCount, ITestSuiteElement parent, String displayName, String data) {
        return (TestSuiteElement)this.fSessionNotifier.testTreeEntry(testId, testName, true, testCount, testCount == null, parent, displayName, data);
    }

    @Override
    public void notifyTestSessionAborted(Duration reportDuration, Exception cause) {
        if (this.isStopped()) {
            return;
        }
        if (reportDuration != null) {
            this.setDuration(reportDuration);
        }
        this.fTestRunnerClient.stopMonitoring();
        this.completedOrAborted = true;
        SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

            public void run() {
                fSessionNotifier.testRunStopped(fDuration);
            }
        });
    }

    @Override
    public void notifyTestSessionCompleted(Duration reportDuration) {
        if (this.isStopped()) {
            return;
        }
        if (reportDuration != null) {
            this.setDuration(reportDuration);
        }
        this.fTestRunnerClient.stopMonitoring();
        this.completedOrAborted = true;
        SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

            public void run() {
                fSessionNotifier.testRunEnded(fDuration);
            }
        });
    }

    @Override
    public void notifyTestEnded(final ITestElement test, final boolean isIgnored) {
        if (this.isStopped()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

            public void run() {
                fSessionNotifier.testEnded(test, isIgnored);
            }
        });
    }

    @Override
    public void notifyTestStarted(final ITestElement test) {
        if (this.isStopped()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

            public void run() {
                fSessionNotifier.testStarted(test);
            }
        });
    }

    @Override
    public void notifyTestSessionStarted(final Integer count) {
        if (this.isStopped()) {
            return;
        }
        this.predefinedTestCount = count;
        SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

            public void run() {
                fSessionNotifier.testRunStarted(count);
            }
        });
    }

    @Override
    public void notifyTestFailed(final ITestElement test, final ITestElement.Result status, final boolean isAssumptionFailed, final ITestElement.FailureTrace failureTrace) {
        if (this.isStopped()) {
            return;
        }
        if (status != ITestElement.Result.FAILURE && status != ITestElement.Result.ERROR) {
            throw new IllegalArgumentException("Status has to be FAILURE or ERROR");
        }
        SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

            public void run() {
                fSessionNotifier.testFailed(test, status, isAssumptionFailed, failureTrace);
            }
        });
    }

    @Override
    public Integer getFinalTestCaseCount() {
        if (this.predefinedTestCount != null) {
            return this.predefinedTestCount;
        }
        if (this.getChildren().isEmpty()) {
            return null;
        }
        if (!this.isRunning()) {
            int res = 0;
            for (TestElement child : this.getChildren()) {
                Integer childCount = child.getFinalTestCaseCount();
                if (childCount == null) {
                    return null;
                }
                res += childCount.intValue();
            }
            return res;
        }
        return null;
    }

    @Override
    public ITestElement.Result getTestResult(boolean includeChildren) {
        return this.fTestResult != null ? this.fTestResult : super.getTestResult(includeChildren);
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            UnitTestPlugin.log(exception);
        }
    }

    private final class NoopLaunch
    extends Launch {
        private NoopLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
            super(launchConfiguration, mode, locator);
        }

        public boolean isTerminated() {
            return true;
        }

        public boolean isDisconnected() {
            return true;
        }
    }

    private class TestSessionNotifier {
        private boolean firstStart;

        private TestSessionNotifier() {
        }

        public void testRunStarted(Integer testCount) {
            TestRunSession.this.fStartTime = Instant.now();
            TestRunSession.this.fPredefinedTestCount = testCount;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionStarted();
            }
        }

        public void testRunEnded(Duration duration) {
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionCompleted(duration);
            }
        }

        public void testRunStopped(Duration duration) {
            TestRunSession.this.fIsAborted = true;
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.sessionAborted(duration);
            }
        }

        public ITestElement testTreeEntry(String testId, String testName, boolean isSuite, Integer testCount, boolean isDynamicTest, ITestSuiteElement parent, String displayName, String uniqueId) {
            TestElement testElement = TestRunSession.this.addTreeEntry(testId, testName, isSuite, testCount, isDynamicTest, (TestSuiteElement)parent, displayName, uniqueId);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testAdded(testElement);
            }
            return testElement;
        }

        public void testStarted(ITestElement test) {
            if (!(test instanceof TestCaseElement)) {
                return;
            }
            if (this.firstStart) {
                for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                    listener.runningBegins();
                }
                this.firstStart = false;
            }
            TestRunSession.this.setStatus(test, Status.RUNNING);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testStarted((ITestCaseElement)test);
            }
        }

        public void testEnded(ITestElement testElement, boolean isIgnored) {
            if (testElement == null) {
                return;
            }
            if (!(testElement instanceof TestCaseElement)) {
                if (isIgnored) {
                    ((TestElement)testElement).setAssumptionFailed(true);
                    TestRunSession.this.setStatus(testElement, Status.OK);
                } else {
                    this.logUnexpectedTest(testElement.getId(), testElement);
                }
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            if (isIgnored) {
                testCaseElement.setIgnored(true);
            }
            if (testCaseElement.getStatus() == Status.RUNNING) {
                TestRunSession.this.setStatus(testCaseElement, Status.OK);
            }
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testEnded(testCaseElement);
            }
        }

        public void testFailed(ITestElement testElement, ITestElement.Result status, boolean isAssumptionFailed, ITestElement.FailureTrace trace) {
            if (testElement == null) {
                return;
            }
            if (isAssumptionFailed) {
                ((TestElement)testElement).setAssumptionFailed(true);
                status = ITestElement.Result.OK;
            }
            TestRunSession.this.registerTestFailureStatus((TestElement)testElement, status, trace);
            for (ITestSessionListener listener : TestRunSession.this.fSessionListeners) {
                listener.testFailed(testElement, status, trace);
            }
        }

        private void logUnexpectedTest(String testId, ITestElement testElement) {
            UnitTestPlugin.log(new Exception("Unexpected TestElement type for testId '" + testId + "': " + testElement));
        }
    }
}

