/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.internal.core.ImportDeclaration;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.IInstanceContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.context.INamespaceContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPTraitType;
import org.eclipse.php.internal.core.typeinference.goals.ConstantDeclarationGoal;

public class TypeReferenceEvaluator
extends GoalEvaluator {
    private TypeReference typeReference;
    private IEvaluatedType result;
    private PHPVersion phpVersion;

    public TypeReferenceEvaluator(IGoal goal, TypeReference typeReference) {
        super(goal);
        this.typeReference = typeReference;
        if (goal.getContext() instanceof ISourceModuleContext) {
            this.phpVersion = ProjectOptions.getPHPVersion((IModelElement)((ISourceModuleContext)goal.getContext()).getSourceModule());
        }
    }

    private boolean isSelfOrStatic() {
        String name = this.typeReference.getName();
        if (this.phpVersion != null && PHPVersion.PHP5_4.isLessThan(this.phpVersion)) {
            name = name.toLowerCase();
        }
        return "self".equals(name) || "static".equals(name);
    }

    private boolean isParent() {
        String name = this.typeReference.getName();
        if (this.phpVersion != null && PHPVersion.PHP5_4.isLessThan(this.phpVersion)) {
            name = name.toLowerCase();
        }
        return "parent".equals(name);
    }

    public IGoal[] init() {
        IContext context = this.goal.getContext();
        String elementName = this.typeReference.getName();
        if (this.isSelfOrStatic()) {
            IInstanceContext instanceContext;
            IEvaluatedType instanceType;
            if ((context instanceof MethodContext || context instanceof TypeContext) && (instanceType = (instanceContext = (IInstanceContext)context).getInstanceType()) instanceof PHPClassType) {
                this.result = instanceType;
            }
        } else if (this.isParent()) {
            LinkedList<IEvaluatedType> parentClassTypes;
            block34: {
                final ISourceModule sourceModule = ((ISourceModuleContext)context).getSourceModule();
                parentClassTypes = new LinkedList<IEvaluatedType>();
                if (context instanceof MethodContext) {
                    try {
                        MethodContext methodContext = (MethodContext)context;
                        ModuleDeclaration rootNode = methodContext.getRootNode();
                        final MethodDeclaration methodDecl = methodContext.getMethodNode();
                        rootNode.traverse(new ASTVisitor(){
                            private TypeDeclaration currentType;
                            private boolean found;

                            public boolean visit(MethodDeclaration s) throws Exception {
                                if (s == methodDecl && this.currentType instanceof ClassDeclaration) {
                                    TypeReferenceEvaluator.this.addParentClassTypes(sourceModule, this.currentType, parentClassTypes);
                                    this.found = true;
                                }
                                return !this.found;
                            }

                            public boolean visit(TypeDeclaration s) throws Exception {
                                this.currentType = s;
                                return !this.found;
                            }

                            public boolean endvisit(TypeDeclaration s) throws Exception {
                                this.currentType = null;
                                return super.endvisit(s);
                            }

                            public boolean visit(ASTNode n) throws Exception {
                                return !this.found;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        break block34;
                    }
                }
                if (context instanceof TypeContext) {
                    try {
                        TypeContext typeContext = (TypeContext)context;
                        ModuleDeclaration rootNode = typeContext.getRootNode();
                        IType currentType = PHPModelUtils.getCurrentType(sourceModule, this.typeReference.sourceStart());
                        if (currentType != null) {
                            TypeDeclaration currentTypeDeclaration = PHPModelUtils.getNodeByClass(rootNode, currentType);
                            this.addParentClassTypes(sourceModule, currentTypeDeclaration, parentClassTypes);
                        }
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block34;
                        e.printStackTrace();
                    }
                }
            }
            if (parentClassTypes.size() == 1) {
                this.result = (IEvaluatedType)parentClassTypes.get(0);
            } else if (parentClassTypes.size() > 1) {
                this.result = new AmbiguousType(parentClassTypes.toArray(new IEvaluatedType[parentClassTypes.size()]));
            }
        } else if (PHPSimpleTypes.isHintable(this.typeReference.getName(), this.phpVersion)) {
            this.result = PHPSimpleTypes.fromString(this.typeReference.getName());
        } else {
            String fullyQualifiedName;
            String parentNamespace = null;
            if (context instanceof INamespaceContext) {
                parentNamespace = ((INamespaceContext)context).getNamespace();
            }
            int elementType = 1;
            if (this.typeReference instanceof FullyQualifiedReference) {
                fullyQualifiedName = ((FullyQualifiedReference)this.typeReference).getFullyQualifiedName();
                elementType = ((FullyQualifiedReference)this.typeReference).getElementType();
            } else {
                fullyQualifiedName = this.typeReference.getName();
                fullyQualifiedName = PHPEvaluationUtils.extractArrayType(fullyQualifiedName);
                elementName = PHPModelUtils.extractElementName(fullyQualifiedName);
            }
            ISourceModule sourceModule = ((ISourceModuleContext)context).getSourceModule();
            int offset = this.typeReference.sourceStart();
            try {
                IModelElement element = sourceModule.getElementAt(offset);
                if (element instanceof ImportDeclaration) {
                    fullyQualifiedName = ((ImportDeclaration)element).getElementName();
                    elementName = PHPModelUtils.extractElementName(fullyQualifiedName);
                    String namespace = PHPModelUtils.extractNameSpaceName(fullyQualifiedName);
                    if (namespace != null && namespace.length() > 0 && namespace.charAt(0) != '\\') {
                        namespace = "\\" + namespace;
                    }
                    if (elementType == 3) {
                        return new IGoal[]{new ConstantDeclarationGoal(this.goal.getContext(), elementName, namespace)};
                    }
                    if (elementType == 1) {
                        this.result = namespace != null ? new PHPClassType(namespace, elementName) : new PHPClassType(elementName);
                    }
                    return IGoal.NO_GOALS;
                }
            }
            catch (ModelException modelException) {}
            String extractedNamespace = PHPModelUtils.extractNamespaceName(fullyQualifiedName, sourceModule, offset);
            if (extractedNamespace != null) {
                parentNamespace = extractedNamespace;
                elementName = PHPModelUtils.getRealName(extractedNamespace, fullyQualifiedName, sourceModule, offset, elementName);
            }
            if (PHPModelUtils.isInUseTraitStatement(((ISourceModuleContext)context).getRootNode(), this.typeReference.sourceStart())) {
                this.result = parentNamespace != null ? new PHPTraitType(parentNamespace, elementName) : new PHPTraitType(elementName);
            } else if (parentNamespace != null) {
                if (elementType == 3) {
                    return new IGoal[]{new ConstantDeclarationGoal(this.goal.getContext(), elementName, parentNamespace)};
                }
                this.result = new PHPClassType(parentNamespace, elementName);
            } else {
                this.result = new PHPClassType(elementName);
            }
            if (PHPEvaluationUtils.isArrayType(this.typeReference.getName())) {
                MultiTypeType tmp = new MultiTypeType();
                tmp.addType(this.result);
                this.result = tmp;
            }
        }
        return IGoal.NO_GOALS;
    }

    private void addParentClassTypes(ISourceModule sourceModule, TypeDeclaration currentTypeDeclaration, List<IEvaluatedType> parentClassTypes) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, currentTypeDeclaration.sourceStart());
        if (currentTypeDeclaration instanceof ClassDeclaration) {
            ClassDeclaration classDecl = (ClassDeclaration)currentTypeDeclaration;
            ASTListNode superClasses = classDecl.getSuperClasses();
            List childs = superClasses.getChilds();
            for (ASTNode node : childs) {
                Object type;
                String fullName;
                Map<String, UsePart> result;
                String prefix;
                NamespaceReference namespace = null;
                SimpleReference reference = null;
                if (!(node instanceof SimpleReference)) continue;
                reference = (SimpleReference)node;
                String typeName = reference.getName();
                if (reference instanceof FullyQualifiedReference) {
                    FullyQualifiedReference ref = (FullyQualifiedReference)node;
                    namespace = ref.getNamespace();
                }
                if (namespace != null && !namespace.getName().equals("")) {
                    String nsName = namespace.getName();
                    if (nsName.equals("\\")) {
                        typeName = String.valueOf(nsName) + typeName;
                    } else {
                        if (nsName.startsWith("namespace\\")) {
                            nsName = nsName.replace("namespace\\", "");
                        }
                        typeName = String.valueOf(nsName) + '\\' + typeName;
                    }
                }
                if (typeName.indexOf(92) > 0) {
                    prefix = typeName.substring(0, typeName.indexOf(92));
                    result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, reference.sourceStart(), currentNamespace, true);
                    if (result.containsKey(prefix) && (typeName = typeName.replace(prefix, fullName = result.get(prefix).getFullUseStatementName())).length() > 0 && typeName.charAt(0) != '\\') {
                        typeName = String.valueOf('\\') + typeName;
                    }
                } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, moduleDeclaration, reference.sourceStart(), currentNamespace, true)).containsKey(prefix) && (typeName = (fullName = result.get(prefix).getFullUseStatementName())).length() > 0 && typeName.charAt(0) != '\\') {
                    typeName = String.valueOf('\\') + typeName;
                }
                if ((type = PHPSimpleTypes.fromString(typeName)) == null) {
                    type = typeName.indexOf(92) != -1 || currentNamespace == null ? new PHPClassType(typeName) : new PHPClassType(currentNamespace.getElementName(), typeName);
                }
                parentClassTypes.add((IEvaluatedType)type);
            }
        }
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (result instanceof IEvaluatedType) {
            this.result = (IEvaluatedType)result;
        }
        return IGoal.NO_GOALS;
    }
}

