/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.util;

import java.io.Reader;

public class RandomAccessCharArrayReader
extends Reader {
    private char[] input;
    private int position;

    public RandomAccessCharArrayReader(char[] input) {
        this.input = input;
    }

    @Override
    public void close() {
        this.input = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.input == null) {
            throw new IllegalStateException("The char array reader was closed.");
        }
        int result = len;
        if (len + this.position >= this.input.length) {
            result = len = this.input.length - this.position;
        }
        if (result <= 0) {
            return -1;
        }
        System.arraycopy(this.input, this.position, cbuf, off, len);
        this.position += len;
        return result;
    }

    public void reset(int position) {
        if (this.input == null) {
            throw new IllegalStateException("The char array reader was closed.");
        }
        if (position < 0 || position >= this.input.length) {
            throw new IllegalArgumentException("Illegal position (got " + position + " for a character array in the length of " + this.input.length);
        }
        this.position = position;
    }
}

