/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.RemoteTargetHandle;

public class TargetReferenceBundleContainer
extends AbstractBundleContainer {
    public static final String ATTRIBUTE_URI = "uri";
    public static final String TYPE = "Target";
    private String uri;
    private volatile ITargetDefinition targetDefinition;

    public TargetReferenceBundleContainer(String uri) {
        this.uri = uri;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        return this.getTarget(monitor).getBundles();
    }

    @Override
    protected int getResolveBundlesWork() {
        return 99;
    }

    @Override
    protected int getResolveFeaturesWork() {
        return 1;
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        return this.getTarget(monitor).getAllFeatures();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.resolveVariables(this.uri);
        }
        return this.uri;
    }

    @Override
    public String serialize() {
        return String.format("<location %s=\"%s\" type=\"%s\" />", ATTRIBUTE_URI, this.getUri(), TYPE);
    }

    public String getUri() {
        return this.uri;
    }

    private synchronized ITargetDefinition getTargetDefinition() throws CoreException {
        if (this.targetDefinition == null) {
            ITargetDefinition definition;
            this.targetDefinition = definition = RemoteTargetHandle.get(this.uri).getTargetDefinition();
            return definition;
        }
        return this.targetDefinition;
    }

    public Optional<ITargetDefinition> targetDefinition() {
        return Optional.ofNullable(this.targetDefinition);
    }

    public void reload() {
        this.targetDefinition = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITargetDefinition getTarget(IProgressMonitor monitor) throws CoreException {
        ITargetDefinition definition;
        ITargetDefinition iTargetDefinition = definition = this.getTargetDefinition();
        synchronized (iTargetDefinition) {
            if (!definition.isResolved()) {
                IStatus status = definition.resolve(monitor);
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                MultiStatus bundleStatus = new MultiStatus(this.getClass(), 0, Messages.TargetRefrenceBundleContainer_Failure);
                Optional.ofNullable(definition.getBundles()).stream().flatMap(Arrays::stream).map(TargetBundle::getStatus).filter(Predicate.not(IStatus::isOK)).forEach(arg_0 -> ((MultiStatus)bundleStatus).add(arg_0));
                if (!bundleStatus.isOK()) {
                    throw new CoreException(status);
                }
            }
            return definition;
        }
    }
}

