/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateChildViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.usecase.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.usecase.providers.UMLElementTypes;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateChildViewOperation) {
            View container = ((CreateChildViewOperation)operation).getContainerView();
            Diagram diagram = container.getDiagram();
            if (!this.getDiagramProvidedId().equals(diagram.getType())) {
                return false;
            }
        }
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        String visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "UseCase";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "UseCase".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != null && !UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())).isEmpty();
    }

    protected boolean provides(CreateNodeViewOperation op) {
        String visualID;
        block55: {
            EObject domainElement;
            block56: {
                IElementType elementType;
                block54: {
                    if (op.getContainerView() == null) {
                        return false;
                    }
                    elementType = this.getSemanticElementType(op.getSemanticAdapter());
                    domainElement = this.getSemanticElement(op.getSemanticAdapter());
                    if (op.getSemanticHint() != null) break block54;
                    if (elementType != null || domainElement == null) {
                        return false;
                    }
                    visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
                    break block55;
                }
                visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
                if (elementType == null) break block56;
                if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                break block55;
            }
            if (!"UseCase".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                return false;
            }
            if (visualID == null) break block55;
            switch (visualID) {
                case "Constraint_Shape": 
                case "Actor_Shape_CCN": 
                case "Package_Shape": 
                case "Package_Shape_CN": 
                case "Constraint_Shape_CCN": 
                case "UseCase_Shape": 
                case "Actor_Shape": 
                case "Component_Shape_CCN": 
                case "Component_Shape_CN": 
                case "NamedElement_DefaultShape": 
                case "UseCase_Shape_CN": 
                case "Actor_ClassifierShape": 
                case "Classifier_SubjectShape": 
                case "Comment_Shape": 
                case "Diagram_ShortcutShape": 
                case "UseCase_Shape_CCN": 
                case "ExtensionPoint_ClassifierExtensionPointLabel": 
                case "ExtensionPoint_ExtensionPointLabel": 
                case "Actor_Shape_CN": 
                case "Comment_Shape_CN": 
                case "Constraint_Shape_CN": 
                case "UseCase_ClassifierShape": {
                    if (domainElement != null && visualID.equals(UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement))) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        return elementTypeHint != null && (op.getSemanticHint() == null || elementTypeHint.equals(op.getSemanticHint()));
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramVersioningUtils.stampCurrentVersion((Diagram)diagram);
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("UseCase");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        block70: {
            EObject domainElement = this.getSemanticElement(semanticAdapter);
            String visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
            if (visualID == null) break block70;
            switch (visualID) {
                case "Actor_Shape": {
                    return this.createActor_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Actor_ClassifierShape": {
                    return this.createActor_ClassifierShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "UseCase_Shape": {
                    return this.createUseCase_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "UseCase_ClassifierShape": {
                    return this.createUseCase_ClassifierShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Classifier_SubjectShape": {
                    return this.createClassifier_SubjectShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Package_Shape": {
                    return this.createPackage_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Constraint_Shape": {
                    return this.createConstraint_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Comment_Shape": {
                    return this.createComment_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "NamedElement_DefaultShape": {
                    return this.createNamedElement_DefaultShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Diagram_ShortcutShape": {
                    return this.createDiagram_ShortcutShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "ExtensionPoint_ExtensionPointLabel": {
                    return this.createExtensionPoint_ExtensionPointLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "ExtensionPoint_ClassifierExtensionPointLabel": {
                    return this.createExtensionPoint_ClassifierExtensionPointLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "UseCase_Shape_CCN": {
                    return this.createUseCase_Shape_CCN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Component_Shape_CCN": {
                    return this.createComponent_Shape_CCN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Comment_Shape_CN": {
                    return this.createComment_Shape_CN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Constraint_Shape_CCN": {
                    return this.createConstraint_Shape_CCN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Actor_Shape_CCN": {
                    return this.createActor_Shape_CCN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Constraint_Shape_CN": {
                    return this.createConstraint_Shape_CN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Actor_Shape_CN": {
                    return this.createActor_Shape_CN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "UseCase_Shape_CN": {
                    return this.createUseCase_Shape_CN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Component_Shape_CN": {
                    return this.createComponent_Shape_CN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Package_Shape_CN": {
                    return this.createPackage_Shape_CN(domainElement, containerView, index, persisted, preferencesHint);
                }
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        block40: {
            IElementType elementType = this.getSemanticElementType(semanticAdapter);
            String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
            String vid = UMLVisualIDRegistry.getVisualID(elementTypeHint);
            if (vid == null) break block40;
            switch (vid) {
                case "Include_Edge": {
                    return this.createInclude_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Extend_Edge": {
                    return this.createExtend_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Generalization_Edge": {
                    return this.createGeneralization_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Association_Edge": {
                    return this.createAssociation_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Constraint_ConstrainedElementEdge": {
                    return this.createConstraint_ConstrainedElementEdge(containerView, index, persisted, preferencesHint);
                }
                case "Dependency_Edge": {
                    return this.createDependency_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Comment_AnnotatedElementEdge": {
                    return this.createComment_AnnotatedElementEdge(containerView, index, persisted, preferencesHint);
                }
                case "Abstraction_Edge": {
                    return this.createAbstraction_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Usage_Edge": {
                    return this.createUsage_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Realization_Edge": {
                    return this.createRealization_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "PackageMerge_Edge": {
                    return this.createPackageMerge_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "PackageImport_Edge": {
                    return this.createPackageImport_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
            }
        }
        return null;
    }

    public Node createActor_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Actor_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        Node actor_NameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_NameLabel"));
        actor_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_NameLabel_Location = (Location)actor_NameLabel.getLayoutConstraint();
        actor_NameLabel_Location.setX(0);
        actor_NameLabel_Location.setY(15);
        Node actor_StereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_StereotypeLabel"));
        actor_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_StereotypeLabel_Location = (Location)actor_StereotypeLabel.getLayoutConstraint();
        actor_StereotypeLabel_Location.setX(20);
        actor_StereotypeLabel_Location.setY(100);
        Node actor_QualifiedNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_QualifiedNameLabel"));
        actor_QualifiedNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_QualifiedNameLabel_Location = (Location)actor_QualifiedNameLabel.getLayoutConstraint();
        actor_QualifiedNameLabel_Location.setX(20);
        actor_QualifiedNameLabel_Location.setY(80);
        Node actor_FloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_FloatingNameLabel"));
        actor_FloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_FloatingNameLabel_Location = (Location)actor_FloatingNameLabel.getLayoutConstraint();
        actor_FloatingNameLabel_Location.setX(0);
        actor_FloatingNameLabel_Location.setY(15);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        return node;
    }

    public Node createActor_ClassifierShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Actor_ClassifierShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_ClassifierNameLabel"));
        return node;
    }

    public Node createUseCase_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("UseCase_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_NameLabel"));
        Node useCase_FloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_FloatingNameLabel"));
        useCase_FloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location useCase_FloatingNameLabel_Location = (Location)useCase_FloatingNameLabel.getLayoutConstraint();
        useCase_FloatingNameLabel_Location.setX(0);
        useCase_FloatingNameLabel_Location.setY(15);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("UseCase_ExtensionPointCompartment"), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        return node;
    }

    public Node createUseCase_ClassifierShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("UseCase_ClassifierShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_ClassifierNameLabel"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("UseCase_ClassifierExtensionPointCompartment"), true, true, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        return node;
    }

    public Node createClassifier_SubjectShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Classifier_SubjectShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Classifier");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Classifier_NameLabel"));
        Node classifier_FloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Classifier_FloatingNameLabel"));
        classifier_FloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location classifier_FloatingNameLabel_Location = (Location)classifier_FloatingNameLabel.getLayoutConstraint();
        classifier_FloatingNameLabel_Location.setX(0);
        classifier_FloatingNameLabel_Location.setY(15);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Classifier_UseCaseCompartment"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Classifier");
        return node;
    }

    public Node createPackage_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Package_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Package");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Package_NameLabel"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Package_PackagedElementCompartment"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Package");
        return node;
    }

    public Node createConstraint_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Constraint_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_NameLabel"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_BodyLabel"));
        return node;
    }

    public Node createComment_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Comment_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Comment_BodyLabel"));
        return node;
    }

    public Node createNamedElement_DefaultShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("NamedElement_DefaultShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DefaultNamedElement");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("NamedElement_NameLabel"));
        return node;
    }

    public Node createDiagram_ShortcutShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Diagram_ShortcutShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ShortCutDiagram");
        Node diagram_NameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Diagram_NameLabel"));
        diagram_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location diagram_NameLabel_Location = (Location)diagram_NameLabel.getLayoutConstraint();
        diagram_NameLabel_Location.setX(0);
        diagram_NameLabel_Location.setY(15);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ShortCutDiagram");
        return node;
    }

    public Node createExtensionPoint_ExtensionPointLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("ExtensionPoint_ExtensionPointLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExtensionPoint");
        return node;
    }

    public Node createExtensionPoint_ClassifierExtensionPointLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("ExtensionPoint_ClassifierExtensionPointLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExtensionPoint");
        return node;
    }

    public Node createUseCase_Shape_CCN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("UseCase_Shape_CCN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_NameLabel_CCN"));
        Node useCase_FloatingNameLabel_CCN = this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_FloatingNameLabel_CCN"));
        useCase_FloatingNameLabel_CCN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location useCase_FloatingNameLabel_CCN_Location = (Location)useCase_FloatingNameLabel_CCN.getLayoutConstraint();
        useCase_FloatingNameLabel_CCN_Location.setX(0);
        useCase_FloatingNameLabel_CCN_Location.setY(15);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("UseCase_ExtensionPointCompartment_CCN"), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        return node;
    }

    public Node createComponent_Shape_CCN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Component_Shape_CCN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Component_NameLabel_CCN"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Component_PackagedElementCompartment_CCN"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        return node;
    }

    public Node createComment_Shape_CN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Comment_Shape_CN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Comment_BodyLabel_CN"));
        return node;
    }

    public Node createConstraint_Shape_CCN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Constraint_Shape_CCN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_NameLabel_CCN"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_BodyLabel_CCN"));
        return node;
    }

    public Node createActor_Shape_CCN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Actor_Shape_CCN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        Node actor_NameLabel_CCN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_NameLabel_CCN"));
        actor_NameLabel_CCN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_NameLabel_CCN_Location = (Location)actor_NameLabel_CCN.getLayoutConstraint();
        actor_NameLabel_CCN_Location.setX(20);
        actor_NameLabel_CCN_Location.setY(60);
        Node actor_StereotypeLabel_CCN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_StereotypeLabel_CCN"));
        actor_StereotypeLabel_CCN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_StereotypeLabel_CCN_Location = (Location)actor_StereotypeLabel_CCN.getLayoutConstraint();
        actor_StereotypeLabel_CCN_Location.setX(20);
        actor_StereotypeLabel_CCN_Location.setY(100);
        Node actor_QualifiedNameLabel_CCN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_QualifiedNameLabel_CCN"));
        actor_QualifiedNameLabel_CCN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_QualifiedNameLabel_CCN_Location = (Location)actor_QualifiedNameLabel_CCN.getLayoutConstraint();
        actor_QualifiedNameLabel_CCN_Location.setX(20);
        actor_QualifiedNameLabel_CCN_Location.setY(80);
        Node actor_FloatingNameLabel_CCN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_FloatingNameLabel_CCN"));
        actor_FloatingNameLabel_CCN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_FloatingNameLabel_CCN_Location = (Location)actor_FloatingNameLabel_CCN.getLayoutConstraint();
        actor_FloatingNameLabel_CCN_Location.setX(0);
        actor_FloatingNameLabel_CCN_Location.setY(15);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        return node;
    }

    public Node createConstraint_Shape_CN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Constraint_Shape_CN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_NameLabel_CN"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_BodyLabel_CN"));
        return node;
    }

    public Node createActor_Shape_CN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Actor_Shape_CN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        Node actor_NameLabel_CN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_NameLabel_CN"));
        actor_NameLabel_CN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_NameLabel_CN_Location = (Location)actor_NameLabel_CN.getLayoutConstraint();
        actor_NameLabel_CN_Location.setX(0);
        actor_NameLabel_CN_Location.setY(15);
        Node actor_StereotypeLabel_CN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_StereotypeLabel_CN"));
        actor_StereotypeLabel_CN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_StereotypeLabel_CN_Location = (Location)actor_StereotypeLabel_CN.getLayoutConstraint();
        actor_StereotypeLabel_CN_Location.setX(20);
        actor_StereotypeLabel_CN_Location.setY(100);
        Node actor_QualifiedNameLabel_CN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_QualifiedNameLabel_CN"));
        actor_QualifiedNameLabel_CN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_QualifiedNameLabel_CN_Location = (Location)actor_QualifiedNameLabel_CN.getLayoutConstraint();
        actor_QualifiedNameLabel_CN_Location.setX(20);
        actor_QualifiedNameLabel_CN_Location.setY(80);
        Node actor_FloatingNameLabel_CN = this.createLabel((View)node, UMLVisualIDRegistry.getType("Actor_FloatingNameLabel_CN"));
        actor_FloatingNameLabel_CN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location actor_FloatingNameLabel_CN_Location = (Location)actor_FloatingNameLabel_CN.getLayoutConstraint();
        actor_FloatingNameLabel_CN_Location.setX(0);
        actor_FloatingNameLabel_CN_Location.setY(15);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        return node;
    }

    public Node createUseCase_Shape_CN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("UseCase_Shape_CN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_NameLabel_CN"));
        Node useCase_FloatingNameLabel_CN = this.createLabel((View)node, UMLVisualIDRegistry.getType("UseCase_FloatingNameLabel_CN"));
        useCase_FloatingNameLabel_CN.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location useCase_FloatingNameLabel_CN_Location = (Location)useCase_FloatingNameLabel_CN.getLayoutConstraint();
        useCase_FloatingNameLabel_CN_Location.setX(0);
        useCase_FloatingNameLabel_CN_Location.setY(15);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("UseCase_ExtensionPointCompartment_CN"), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        return node;
    }

    public Node createComponent_Shape_CN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Component_Shape_CN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Component_NameLabel_CN"));
        Node component_FloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Component_FloatingNameLabel"));
        component_FloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location component_FloatingNameLabel_Location = (Location)component_FloatingNameLabel.getLayoutConstraint();
        component_FloatingNameLabel_Location.setX(0);
        component_FloatingNameLabel_Location.setY(15);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Component_PackagedElementCompartment_CN"), true, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        return node;
    }

    public Node createPackage_Shape_CN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Package_Shape_CN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Package");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Package_NameLabel_CN"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Package_PackagedElementCompartment_CN"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Package");
        return node;
    }

    public Edge createInclude_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Include_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Include");
        Node include_KeywordLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Include_KeywordLabel"));
        include_KeywordLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location include_KeywordLabel_Location = (Location)include_KeywordLabel.getLayoutConstraint();
        include_KeywordLabel_Location.setX(0);
        include_KeywordLabel_Location.setY(20);
        Node include_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Include_StereotypeLabel"));
        include_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location include_StereotypeLabel_Location = (Location)include_StereotypeLabel.getLayoutConstraint();
        include_StereotypeLabel_Location.setX(0);
        include_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Include");
        return edge;
    }

    public Edge createExtend_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Extend_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Extend");
        Node extend_KeywordLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Extend_KeywordLabel"));
        extend_KeywordLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location extend_KeywordLabel_Location = (Location)extend_KeywordLabel.getLayoutConstraint();
        extend_KeywordLabel_Location.setX(0);
        extend_KeywordLabel_Location.setY(20);
        Node extend_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Extend_StereotypeLabel"));
        extend_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location extend_StereotypeLabel_Location = (Location)extend_StereotypeLabel.getLayoutConstraint();
        extend_StereotypeLabel_Location.setX(0);
        extend_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Extend");
        return edge;
    }

    public Edge createGeneralization_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Generalization_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Generalization");
        Node generalization_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Generalization_StereotypeLabel"));
        generalization_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location generalization_StereotypeLabel_Location = (Location)generalization_StereotypeLabel.getLayoutConstraint();
        generalization_StereotypeLabel_Location.setX(0);
        generalization_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Generalization");
        return edge;
    }

    public Edge createAssociation_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Association_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Association");
        Node association_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Association_NameLabel"));
        association_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location association_NameLabel_Location = (Location)association_NameLabel.getLayoutConstraint();
        association_NameLabel_Location.setX(0);
        association_NameLabel_Location.setY(40);
        Node association_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Association_StereotypeLabel"));
        association_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location association_StereotypeLabel_Location = (Location)association_StereotypeLabel.getLayoutConstraint();
        association_StereotypeLabel_Location.setX(0);
        association_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Association");
        return edge;
    }

    public Edge createConstraint_ConstrainedElementEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        edge.setElement(null);
        return edge;
    }

    public Edge createDependency_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Dependency_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Dependency");
        Node dependency_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Dependency_NameLabel"));
        dependency_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location dependency_NameLabel_Location = (Location)dependency_NameLabel.getLayoutConstraint();
        dependency_NameLabel_Location.setX(0);
        dependency_NameLabel_Location.setY(40);
        Node dependency_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Dependency_StereotypeLabel"));
        dependency_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location dependency_StereotypeLabel_Location = (Location)dependency_StereotypeLabel.getLayoutConstraint();
        dependency_StereotypeLabel_Location.setX(0);
        dependency_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Dependency");
        return edge;
    }

    public Edge createComment_AnnotatedElementEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        edge.setElement(null);
        return edge;
    }

    public Edge createAbstraction_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Abstraction_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Abstraction");
        Node abstraction_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Abstraction_NameLabel"));
        abstraction_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location abstraction_NameLabel_Location = (Location)abstraction_NameLabel.getLayoutConstraint();
        abstraction_NameLabel_Location.setX(0);
        abstraction_NameLabel_Location.setY(40);
        Node abstraction_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Abstraction_StereotypeLabel"));
        abstraction_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location abstraction_StereotypeLabel_Location = (Location)abstraction_StereotypeLabel.getLayoutConstraint();
        abstraction_StereotypeLabel_Location.setX(0);
        abstraction_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Abstraction");
        return edge;
    }

    public Edge createUsage_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Usage_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Usage");
        Node usage_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Usage_NameLabel"));
        usage_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location usage_NameLabel_Location = (Location)usage_NameLabel.getLayoutConstraint();
        usage_NameLabel_Location.setX(0);
        usage_NameLabel_Location.setY(40);
        Node usage_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Usage_StereotypeLabel"));
        usage_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location usage_StereotypeLabel_Location = (Location)usage_StereotypeLabel.getLayoutConstraint();
        usage_StereotypeLabel_Location.setX(0);
        usage_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Usage");
        return edge;
    }

    public Edge createRealization_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Realization_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Realization");
        Node realization_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Realization_NameLabel"));
        realization_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location realization_NameLabel_Location = (Location)realization_NameLabel.getLayoutConstraint();
        realization_NameLabel_Location.setX(0);
        realization_NameLabel_Location.setY(40);
        Node realization_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Realization_StereotypeLabel"));
        realization_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location realization_StereotypeLabel_Location = (Location)realization_StereotypeLabel.getLayoutConstraint();
        realization_StereotypeLabel_Location.setX(0);
        realization_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Realization");
        return edge;
    }

    public Edge createPackageMerge_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("PackageMerge_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"PackageMerge");
        Node packageMerge_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("PackageMerge_StereotypeLabel"));
        packageMerge_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location packageMerge_StereotypeLabel_Location = (Location)packageMerge_StereotypeLabel.getLayoutConstraint();
        packageMerge_StereotypeLabel_Location.setX(0);
        packageMerge_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"PackageMerge");
        return edge;
    }

    public Edge createPackageImport_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("PackageImport_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"PackageImport");
        Node packageImport_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("PackageImport_StereotypeLabel"));
        packageImport_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location packageImport_StereotypeLabel_Location = (Location)packageImport_StereotypeLabel.getLayoutConstraint();
        packageImport_StereotypeLabel_Location.setX(0);
        packageImport_StereotypeLabel_Location.setY(-20);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"PackageImport");
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"UseCase".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"UseCase");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        BasicCompartment rv = NotationFactory.eINSTANCE.createBasicCompartment();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

