/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.composite.dialog;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.ui.editor.DiagramComposite;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DoubleDiagramDialog
extends Dialog {
    private IResource firstResource;
    private IResource secondResource;

    public DoubleDiagramDialog(Shell parentShell, IResource firstResource, IResource secondResource) {
        super(parentShell);
        this.firstResource = firstResource;
        this.secondResource = secondResource;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)control.getLayout();
        layout.numColumns = 2;
        URI diagramURI = URI.createPlatformResourceURI((String)this.firstResource.getFullPath().toString(), (boolean)true);
        DiagramComposite diagramComposite = new DiagramComposite(control, 2048);
        DiagramEditorInput input = new DiagramEditorInput(diagramURI, null);
        diagramComposite.setInput((IDiagramEditorInput)input);
        URI diagramURI2 = URI.createPlatformResourceURI((String)this.secondResource.getFullPath().toString(), (boolean)true);
        DiagramComposite diagramComposite2 = new DiagramComposite(control, 2048);
        DiagramEditorInput input2 = new DiagramEditorInput(diagramURI2, null);
        diagramComposite2.setInput((IDiagramEditorInput)input2);
        return control;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Two Diagrams Popup (Graphiti Example)");
    }
}

