/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColoursAndFontsAndLineStylesPropertySection;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ConnectionAppearancePropertySection
extends ColoursAndFontsAndLineStylesPropertySection {
    protected static final String REVERSE_JUMP_LINKS_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_ReverseJumpLinksLabel_Text;
    private static final String ROUTER_OPTIONS_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_RouterOptionsLabel_Text;
    protected static final String AVOID_OBSTACLES_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_AvoidObstaclesLabel_Text;
    protected static final String CLOSEST_DISTANCE_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_ClosestDistanceLabel_Text;
    protected static final String LINE_ROUTER_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_LineRouterLabel_Text;
    protected static final String SMOOTHNESS_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_SmoothnessLabel_Text;
    protected static final String JUMP_LINKS_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_JumpLinksLabel_Text;
    protected static final String JUMP_LINK_TYPE_NAME_LABEL = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_JumpLinkTypeLabel_Text;
    private static final String JUMP_LINKS_GROUP_NAME = DiagramUIPropertiesMessages.ConnectionAppearanceDetails_JumpLinkGroupLabel_Text;
    protected Map buttons = new HashMap();
    private Button avoidObstaclesButton;
    private Button closestDistanceButton;
    private Button reverseJumpLinksButton;

    private void updateModel(String szCmd, final String szID, final Object val) {
        if (this.isReadOnly()) {
            this.refresh();
            return;
        }
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (final ConnectionEditPart ep : this.getInput()) {
            Resource res = ((View)ep.getModel()).eResource();
            commands.add(this.createCommand(szCmd, res, new Runnable(){

                @Override
                public void run() {
                    ENamedElement element = PackageUtil.getElement((String)szID);
                    if (element instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue((EStructuralFeature)element, val);
                    }
                }
            }));
        }
        this.executeAsCompositeCommand(szCmd, commands);
    }

    @Override
    protected void initializeControls(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout layout = (FormLayout)this.composite.getLayout();
        layout.spacing = 3;
        Composite groups = this.getWidgetFactory().createComposite(this.composite);
        groups.setLayout((Layout)new GridLayout(2, false));
        this.createFontsAndColorsGroups(groups);
        this.colorsAndFontsGroup.setLayoutData((Object)new GridData(2));
        this.createConnectionPropertyGroups(groups);
    }

    public void createConnectionPropertyGroups(Composite groups) {
        Group routing = this.getWidgetFactory().createGroup(groups, ROUTER_OPTIONS_LABEL);
        routing.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(768);
        routing.setLayoutData((Object)data);
        Composite left = this.getWidgetFactory().createComposite(groups);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        left.setLayout((Layout)layout);
        data = new GridData(1808);
        left.setLayoutData((Object)data);
        this.createLineStylesGroup(left);
        this.lineStylesGroup.setLayoutData((Object)new GridData(1808));
        this.createRadioGroup(left, Smoothness.VALUES.iterator(), Properties.ID_SMOOTHNESS, DiagramUIPropertiesMessages.AppearanceDetails_SmoothnessCommand_Text, SMOOTHNESS_NAME_LABEL, 2);
        this.createRadioGroup((Composite)routing, Routing.VALUES.iterator(), Properties.ID_ROUTING, DiagramUIPropertiesMessages.AppearanceDetails_LineRouterCommand_Text, LINE_ROUTER_NAME_LABEL, 3);
        this.createRouterOptionsGroup((Composite)routing);
        Group jumpLinks = this.getWidgetFactory().createGroup(groups, JUMP_LINKS_GROUP_NAME);
        jumpLinks.setLayout((Layout)new GridLayout(2, false));
        data = new GridData(768);
        jumpLinks.setLayoutData((Object)data);
        this.createRadioGroup((Composite)jumpLinks, JumpLinkStatus.VALUES.iterator(), Properties.ID_JUMPLINKS_STATUS, DiagramUIPropertiesMessages.AppearanceDetails_JumpLinksCommand_Text, JUMP_LINKS_NAME_LABEL, 2);
        this.createRadioGroup((Composite)jumpLinks, JumpLinkType.VALUES.iterator(), Properties.ID_JUMPLINKS_TYPE, DiagramUIPropertiesMessages.AppearanceDetails_JumpLinkTypeCommand_Text, JUMP_LINK_TYPE_NAME_LABEL, 2);
        Composite jumpLinksComposite = this.getWidgetFactory().createComposite((Composite)jumpLinks);
        jumpLinksComposite.setLayout((Layout)new GridLayout(2, false));
        this.reverseJumpLinksButton = this.getWidgetFactory().createButton(jumpLinksComposite, REVERSE_JUMP_LINKS_NAME_LABEL, 32);
        this.reverseJumpLinksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionAppearancePropertySection.this.updateModel(DiagramUIPropertiesMessages.AppearanceDetails_ReverseJumpLinksCommand_Text, Properties.ID_JUMPLINKS_REVERSE, ConnectionAppearancePropertySection.this.reverseJumpLinksButton.getSelection());
            }
        });
    }

    protected void createRouterOptionsGroup(Composite groups) {
        Composite routerOptionsGroup = this.getWidgetFactory().createComposite(groups);
        GridData data = new GridData(768);
        routerOptionsGroup.setLayoutData((Object)data);
        routerOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.avoidObstaclesButton = this.getWidgetFactory().createButton(routerOptionsGroup, AVOID_OBSTACLES_NAME_LABEL, 32);
        this.avoidObstaclesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionAppearancePropertySection.this.updateModel(DiagramUIPropertiesMessages.AppearanceDetails_AvoidObstaclesCommand_Text, Properties.ID_AVOIDOBSTRUCTIONS, ConnectionAppearancePropertySection.this.avoidObstaclesButton.getSelection());
            }
        });
        this.closestDistanceButton = this.getWidgetFactory().createButton(routerOptionsGroup, CLOSEST_DISTANCE_NAME_LABEL, 32);
        this.closestDistanceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionAppearancePropertySection.this.updateModel(DiagramUIPropertiesMessages.AppearanceDetails_ClosestDistanceCommand_Text, Properties.ID_CLOSESTDISTANCE, ConnectionAppearancePropertySection.this.closestDistanceButton.getSelection());
            }
        });
    }

    protected void createRadioGroup(Composite parent, Iterator iterator, final Object propertyId, final String commandName, String propertyName, int rows) {
        Group group = this.getWidgetFactory().createGroup(parent, propertyName);
        group.setLayout((Layout)new GridLayout(rows, true));
        GridData data = new GridData(1808);
        group.setLayoutData((Object)data);
        Button radioButton = null;
        Iterator e = iterator;
        while (e.hasNext()) {
            AbstractEnumerator literal = (AbstractEnumerator)e.next();
            String propertyValueName = this.translate(literal);
            radioButton = this.getWidgetFactory().createButton((Composite)group, propertyValueName, 16);
            radioButton.setData((Object)literal);
            this.buttons.put(literal, radioButton);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ConnectionAppearancePropertySection.this.setPropertyValue(event, propertyId, commandName);
                }
            });
            if (!this.isReadOnly()) continue;
            radioButton.setEnabled(false);
        }
    }

    private String translate(AbstractEnumerator literal) {
        if (JumpLinkType.SEMICIRCLE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_SemiCircle;
        }
        if (JumpLinkType.SQUARE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_Square;
        }
        if (JumpLinkType.CHAMFERED_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_Chamfered;
        }
        if (JumpLinkType.TUNNEL_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksType_Tunnel;
        }
        if (JumpLinkStatus.NONE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_None;
        }
        if (JumpLinkStatus.ALL_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_All;
        }
        if (JumpLinkStatus.BELOW_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_Below;
        }
        if (JumpLinkStatus.ABOVE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_JumplinksStatus_Above;
        }
        if (Smoothness.NONE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothNone;
        }
        if (Smoothness.NORMAL_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothNormal;
        }
        if (Smoothness.LESS_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothLess;
        }
        if (Smoothness.MORE_LITERAL.equals(literal)) {
            return DiagramUIMessages.PropertyDescriptorFactory_Smoothness_SmoothMore;
        }
        if (Routing.MANUAL_LITERAL.equals(literal)) {
            return DiagramUIMessages.ConnectionAppearancePropertySection_Router_Manual;
        }
        if (Routing.RECTILINEAR_LITERAL.equals(literal)) {
            return DiagramUIMessages.ConnectionAppearancePropertySection_Router_Rectilinear;
        }
        if (Routing.TREE_LITERAL.equals(literal)) {
            return DiagramUIMessages.ConnectionAppearancePropertySection_Router_Tree;
        }
        assert (false) : "No translated string available.";
        return "";
    }

    protected void setPropertyValue(SelectionEvent event, final Object propertyId, String commandName) {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInput().iterator();
        final Button button = (Button)event.getSource();
        while (it.hasNext()) {
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            commands.add(this.createCommand(commandName, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ENamedElement element;
                    if (propertyId instanceof String && (element = PackageUtil.getElement((String)((String)propertyId))) instanceof EStructuralFeature) {
                        ep.setStructuralFeatureValue((EStructuralFeature)element, button.getData());
                    }
                }
            }));
        }
        this.executeAsCompositeCommand(commandName, commands);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            try {
                this.executeAsReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Button treeRoutingButton;
                        Button button;
                        Boolean val;
                        Iterator i = ConnectionAppearancePropertySection.this.buttons.keySet().iterator();
                        while (i.hasNext()) {
                            Button radioButton = (Button)ConnectionAppearancePropertySection.this.buttons.get(i.next());
                            radioButton.setSelection(false);
                        }
                        ConnectionEditPart obj = (ConnectionEditPart)ConnectionAppearancePropertySection.this.getSingleInput();
                        if (!ConnectionAppearancePropertySection.this.avoidObstaclesButton.isDisposed()) {
                            val = (Boolean)obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_AvoidObstructions());
                            ConnectionAppearancePropertySection.this.avoidObstaclesButton.setSelection(val.booleanValue());
                        }
                        if (!ConnectionAppearancePropertySection.this.closestDistanceButton.isDisposed()) {
                            val = (Boolean)obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_ClosestDistance());
                            ConnectionAppearancePropertySection.this.closestDistanceButton.setSelection(val.booleanValue());
                        }
                        if (!ConnectionAppearancePropertySection.this.reverseJumpLinksButton.isDisposed()) {
                            val = (Boolean)obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinksReverse());
                            ConnectionAppearancePropertySection.this.reverseJumpLinksButton.setSelection(val.booleanValue());
                        }
                        if ((button = (Button)ConnectionAppearancePropertySection.this.buttons.get(obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkStatus()))) != null) {
                            button.setSelection(true);
                        }
                        if ((button = (Button)ConnectionAppearancePropertySection.this.buttons.get(obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkType()))) != null) {
                            button.setSelection(true);
                        }
                        if ((treeRoutingButton = (Button)ConnectionAppearancePropertySection.this.buttons.get(Routing.TREE_LITERAL)) != null) {
                            treeRoutingButton.setEnabled(obj instanceof ITreeBranchEditPart);
                        }
                        if ((button = (Button)ConnectionAppearancePropertySection.this.buttons.get(obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing()))) != null) {
                            button.setSelection(true);
                        }
                        if ((button = (Button)ConnectionAppearancePropertySection.this.buttons.get(obj.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Smoothness()))) != null) {
                            button.setSelection(true);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

