/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.efs.EgitFileSystem;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.AbstractGitCompareEditorInput;
import org.eclipse.egit.ui.internal.merge.CompareEditorInputViewerAction;
import org.eclipse.egit.ui.internal.merge.GitCompareLabelProvider;
import org.eclipse.egit.ui.internal.merge.MergeDiffNode;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesAction;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.PlatformUI;

public class GitMergeEditorInput
extends AbstractGitCompareEditorInput {
    private static final String LABELPATTERN = "{0} - {1}";
    private final MergeInputMode mode;
    private final boolean useWorkspace;
    private final boolean useOurs;
    private CompareEditorInputViewerAction toggleCurrentChanges;
    private Map<DiffNode, String> customLabels = new IdentityHashMap<DiffNode, String>();

    public GitMergeEditorInput(MergeInputMode mode, IPath ... locations) {
        super(null, locations);
        this.useWorkspace = !MergeInputMode.STAGE_2.equals((Object)mode);
        this.useOurs = MergeInputMode.MERGED_OURS.equals((Object)mode);
        this.mode = mode;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setLeftEditable(true);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(new Object[]{this.mode});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GitMergeEditorInput other = (GitMergeEditorInput)((Object)obj);
        return this.mode == other.mode;
    }

    @Override
    protected void initActions(ToolBarManager manager, Viewer newViewer, ICompareInput input) {
        super.initActions(manager, newViewer, input);
        this.setToggleCurrentChangesAction(manager, newViewer, input);
    }

    private void setToggleCurrentChangesAction(ToolBarManager manager, Viewer newViewer, ICompareInput input) {
        boolean isApplicable = newViewer instanceof ContentMergeViewer && input instanceof MergeDiffNode && input.getAncestor() != null;
        this.setAction(manager, newViewer, isApplicable, "org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesCommand", create -> {
            if (this.toggleCurrentChanges == null && create) {
                this.toggleCurrentChanges = new ToggleCurrentChangesAction(UIText.GitMergeEditorInput_ToggleCurrentChangesLabel, this);
                this.toggleCurrentChanges.setId("org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesCommand");
            }
            return this.toggleCurrentChanges;
        });
    }

    @Override
    protected void disposeActions() {
        if (this.toggleCurrentChanges != null) {
            this.toggleCurrentChanges.dispose();
            this.toggleCurrentChanges = null;
        }
        super.disposeActions();
    }

    public IDiffContainer getDiffContainer(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return (IDiffContainer)this.prepareInput(monitor);
    }

    @Override
    protected GitInfo getGitInfo(final IPath path) {
        return new GitInfo(){

            public Repository getRepository() {
                return GitMergeEditorInput.this.getRepository();
            }

            public String getGitPath() {
                return path.toString();
            }

            public GitInfo.Source getSource() {
                return GitInfo.Source.WORKING_TREE;
            }

            public AnyObjectId getCommitId() {
                return null;
            }
        };
    }

    @Override
    protected DiffContainer buildInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RevWalk rw = null;
        try {
            String fullBranch;
            RevCommit headCommit;
            RevCommit rightCommit;
            Repository repo = this.getRepository();
            rw = new RevWalk(repo);
            try {
                rightCommit = RevCommitUtils.getTheirs((Repository)repo, (RevWalk)rw);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                ObjectId head = repo.resolve("HEAD");
                if (head == null) {
                    throw new IOException(NLS.bind((String)CoreText.ValidationUtils_CanNotResolveRefMessage, (Object)"HEAD"));
                }
                headCommit = rw.parseCommit((AnyObjectId)head);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                fullBranch = repo.getFullBranch();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            CompareConfiguration config = this.getCompareConfiguration();
            RevCommit ancestorCommit = null;
            boolean unknownAncestor = false;
            switch (repo.getRepositoryState()) {
                case CHERRY_PICKING: 
                case REBASING_MERGE: 
                case REBASING_INTERACTIVE: {
                    if (rightCommit.getParentCount() == 1) {
                        try {
                            ancestorCommit = rw.parseCommit((AnyObjectId)rightCommit.getParent(0));
                        }
                        catch (IOException e) {
                            unknownAncestor = true;
                        }
                    } else {
                        unknownAncestor = true;
                    }
                    if (MergeInputMode.WORKTREE.equals((Object)this.mode)) break;
                    config.setChangeIgnored(config.isMirrored() ? 2 : 3, true);
                    config.setChangeIgnored(4, true);
                    break;
                }
                default: {
                    ArrayList<RevCommit> startPoints = new ArrayList<RevCommit>();
                    rw.setRevFilter(RevFilter.MERGE_BASE);
                    startPoints.add(rightCommit);
                    startPoints.add(headCommit);
                    try {
                        rw.markStart(startPoints);
                        ancestorCommit = rw.next();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            config.setRightLabel(NLS.bind((String)LABELPATTERN, (Object)rightCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(rightCommit.name())));
            if (!this.useWorkspace) {
                config.setLeftLabel(NLS.bind((String)LABELPATTERN, (Object)headCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(headCommit.name())));
            } else if (this.useOurs) {
                config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceOursHeader);
            } else {
                config.setLeftLabel(UIText.GitMergeEditorInput_WorkspaceHeader);
            }
            if (ancestorCommit != null) {
                config.setAncestorLabel(NLS.bind((String)LABELPATTERN, (Object)ancestorCommit.getShortMessage(), (Object)CompareUtils.truncatedRevision(ancestorCommit.name())));
            } else if (unknownAncestor) {
                config.setAncestorLabel(NLS.bind((String)UIText.GitMergeEditorInput_AncestorUnknownHeader, (Object)CompareUtils.truncatedRevision(rightCommit.name())));
            }
            this.setTitle(NLS.bind((String)UIText.GitMergeEditorInput_MergeEditorTitle, (Object[])new Object[]{RepositoryUtil.INSTANCE.getRepositoryName(repo), rightCommit.getShortMessage(), fullBranch}));
            try {
                DiffContainer diffContainer = this.buildDiffContainer(repo, headCommit, ancestorCommit, rw, monitor);
                return diffContainer;
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
        }
    }

    @Override
    protected void inputBuilt(DiffContainer root) {
        super.inputBuilt(root);
        this.customLabels.forEach((node, name) -> this.setLeftLabel((DiffNode)node, (String)name, false));
        this.customLabels.clear();
    }

    private DiffContainer buildDiffContainer(Repository repository, RevCommit headCommit, RevCommit ancestorCommit, RevWalk rw, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.setTaskName(UIText.GitMergeEditorInput_CalculatingDiffTaskName);
        DiffNode result = new DiffNode(12);
        MergeCommand.ConflictStyle style = null;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (TreeWalk tw = new TreeWalk(repository);){
                int dirCacheIndex = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
                FileTreeIterator fIter = new FileTreeIterator(repository);
                int fileTreeIndex = tw.addTree((AbstractTreeIterator)fIter);
                fIter.setDirCacheIterator(tw, dirCacheIndex);
                int repositoryTreeIndex = tw.addTree((AnyObjectId)rw.parseTree((AnyObjectId)repository.resolve("HEAD")));
                Collection<String> filterPaths = this.getFilterPaths();
                if (!filterPaths.isEmpty()) {
                    if (filterPaths.size() > 1) {
                        tw.setFilter(PathFilterGroup.createFromStrings(filterPaths));
                    } else {
                        String path = filterPaths.iterator().next();
                        if (!path.isEmpty()) {
                            tw.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{path}));
                        }
                    }
                }
                tw.setRecursive(true);
                while (tw.next()) {
                    ResourceEditableRevision left;
                    ITypedElement right;
                    boolean modified;
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    String gitPath = tw.getPathString();
                    monitor.setTaskName(gitPath);
                    FileTreeIterator fit = (FileTreeIterator)tw.getTree(fileTreeIndex, FileTreeIterator.class);
                    if (fit == null) continue;
                    DirCacheIterator dit = (DirCacheIterator)tw.getTree(dirCacheIndex, DirCacheIterator.class);
                    DirCacheEntry dirCacheEntry = dit == null ? null : dit.getDirCacheEntry();
                    boolean conflicting = dirCacheEntry != null && dirCacheEntry.getStage() > 0;
                    AbstractTreeIterator rt = tw.getTree(repositoryTreeIndex, AbstractTreeIterator.class);
                    boolean bl = modified = rt != null && !fit.getEntryObjectId().equals((AnyObjectId)rt.getEntryObjectId());
                    if (!conflicting && !modified) continue;
                    String encoding = null;
                    if (conflicting) {
                        GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)3);
                        encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                        right = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                    } else {
                        right = CompareUtils.getFileRevisionTypedElement(gitPath, headCommit, repository);
                    }
                    if (right instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) continue;
                    Path repositoryPath = new Path(repository.getWorkTree().getAbsolutePath());
                    IPath location = repositoryPath.append(gitPath);
                    assert (location != null);
                    final IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
                    boolean useWorkingTree = !conflicting || this.useWorkspace;
                    boolean stage2FromWorkingTree = false;
                    if (!useWorkingTree && conflicting && dirCacheEntry != null) {
                        stage2FromWorkingTree = useWorkingTree = !Instant.EPOCH.equals(dirCacheEntry.getLastModifiedInstant());
                    }
                    if (useWorkingTree) {
                        Object item;
                        Attribute markerSize;
                        Attributes attributes;
                        boolean useOursFilter = conflicting && this.useOurs;
                        int conflictMarkerSize = 7;
                        if (useOursFilter && (useOursFilter = (attributes = tw.getAttributes()).canBeContentMerged()) && (markerSize = attributes.get("conflict-marker-size")) != null && Attribute.State.CUSTOM.equals((Object)markerSize.getState())) {
                            try {
                                conflictMarkerSize = Integer.parseUnsignedInt(markerSize.getValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (useOursFilter) {
                            boolean useDiff3Style;
                            if (style == null) {
                                style = (MergeCommand.ConflictStyle)repository.getConfig().getEnum("merge", null, "conflictStyle", (Enum)MergeCommand.ConflictStyle.MERGE);
                            }
                            String filter = String.valueOf((useDiff3Style = MergeCommand.ConflictStyle.DIFF3.equals(style)) ? (char)'O' : 'o') + Integer.toString(conflictMarkerSize);
                            URI uri = EgitFileSystem.createURI((Repository)repository, (String)gitPath, (String)("WORKTREE:" + filter));
                            Charset rscEncoding = null;
                            if (file != null) {
                                if (encoding == null) {
                                    encoding = CompareCoreUtils.getResourceEncoding((IResource)file);
                                }
                                try {
                                    rscEncoding = Charset.forName(encoding);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            item = this.createWithHiddenResource(uri, repository, gitPath, tw.getNameString(), file, rscEncoding);
                            if (file != null) {
                                item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new AbstractGitCompareEditorInput.LocalResourceSaver((LocalResourceTypedElement)item){

                                    @Override
                                    protected void save() throws CoreException {
                                        super.save();
                                        file.refreshLocal(0, null);
                                    }
                                });
                            } else {
                                item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new AbstractGitCompareEditorInput.LocalResourceSaver((LocalResourceTypedElement)item));
                            }
                        } else {
                            item = file != null ? new LocalResourceTypedElement((IResource)file) : new LocalNonWorkspaceTypedElement(repository, location);
                            item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new AbstractGitCompareEditorInput.LocalResourceSaver((LocalResourceTypedElement)item));
                        }
                        left = item;
                    } else {
                        IFile rsc;
                        IFile iFile = rsc = file != null ? file : this.createHiddenResource(location.toFile().toURI(), tw.getNameString(), null);
                        assert (rsc != null);
                        GitFileRevision rev = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)2);
                        ICompareContainer runnableContext = this.getContainer();
                        if (runnableContext == null) {
                            runnableContext = PlatformUI.getWorkbench().getProgressService();
                            assert (runnableContext != null);
                        }
                        left = new ResourceEditableRevision((IFileRevision)rev, rsc, (IRunnableContext)runnableContext);
                        ((EditableRevision)left).addContentChangeListener(source -> this.updateIndexTimestamp(repository, gitPath));
                        try {
                            ((EditableRevision)left).cacheContents(monitor);
                        }
                        catch (CoreException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                    int kind = 0;
                    if (conflicting) {
                        kind = 15;
                    } else if (modified) {
                        kind = 5;
                    }
                    IDiffContainer fileParent = this.getFileParent((IDiffContainer)result, (IPath)repositoryPath, file, location);
                    ITypedElement ancestor = null;
                    if (ancestorCommit != null) {
                        ancestor = CompareUtils.getFileRevisionTypedElement(gitPath, ancestorCommit, repository);
                        if (ancestor instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement) {
                            ancestor = null;
                        }
                    } else if (conflicting) {
                        GitFileRevision revision = GitFileRevision.inIndex((Repository)repository, (String)gitPath, (int)1);
                        if (encoding == null) {
                            encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                        }
                        ancestor = new FileRevisionTypedElement((IFileRevision)revision, encoding);
                    }
                    MergeDiffNode node = new MergeDiffNode(fileParent, kind, ancestor, left, right);
                    if (stage2FromWorkingTree) {
                        this.customLabels.put(node, tw.getNameString());
                        continue;
                    }
                    if (!(left instanceof EditableRevision)) continue;
                    String name = tw.getNameString();
                    ((EditableRevision)left).addContentChangeListener(source -> this.setLeftLabel(node, name, true));
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void updateIndexTimestamp(Repository repository, String gitPath) {
        DirCache cache = null;
        try {
            try {
                cache = repository.lockDirCache();
                DirCacheEditor editor = cache.editor();
                editor.add(new DirCacheEditor.PathEdit(gitPath){
                    private boolean done;

                    public void apply(DirCacheEntry ent) {
                        if (!this.done && ent.getStage() > 0) {
                            ent.setLastModified(Instant.now());
                            this.done = true;
                        }
                    }
                });
                editor.commit();
            }
            catch (IOException e) {
                Activator.logError(MessageFormat.format(UIText.GitMergeEditorInput_ErrorUpdatingIndex, gitPath), e);
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        finally {
            if (cache != null) {
                cache.unlock();
            }
        }
    }

    private void setLeftLabel(DiffNode node, final String name, boolean fireChange) {
        GitCompareLabelProvider labels = new GitCompareLabelProvider(){

            @Override
            public String getLeftLabel(Object input) {
                return MessageFormat.format(UIText.GitCompareFileRevisionEditorInput_LocalLabel, name);
            }

            @Override
            public String getRightLabel(Object input) {
                return null;
            }

            @Override
            public String getAncestorLabel(Object input) {
                return null;
            }
        };
        this.getCompareConfiguration().setLabelProvider((ICompareInput)node, (ICompareInputLabelProvider)labels);
        if (fireChange) {
            labels.fireNodeLabelChanged(node);
        }
    }
}

