/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;
import org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserNestedQueryHelper;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;

public class SaxParserConsumer
implements ISaxParserConsumer {
    private static final int INVALID_COLUMN_INDEX = -1;
    private SaxParser sp;
    private Thread spThread;
    private String[] namesOfNestedColumns;
    private String[] namesOfColumns;
    private Map nameIndexMap;
    private String tableName;
    private MappingPathElementTree mappingPathElementTree;
    private RelationInformation relationInfo;
    private SaxParserNestedQueryHelper spNestedQueryHelper;
    private List processingRows = new ArrayList();
    private List filledRows = new ArrayList(100);
    private PreparedRowsValues prv = new PreparedRowsValues();
    private boolean isContainRowFilter = false;

    public String[] getRowValue() {
        return this.prv.getCurrentRowValues();
    }

    public SaxParserConsumer(RelationInformation rinfo, IXMLSource xmlSource, String tName) throws OdaException {
        this.tableName = tName;
        this.relationInfo = rinfo;
        this.namesOfNestedColumns = this.relationInfo.getTableNestedXMLColumnNames(this.tableName);
        this.namesOfColumns = this.relationInfo.getTableRealColumnNames(this.tableName);
        this.nameIndexMap = new HashMap();
        int i = 0;
        while (i < this.namesOfColumns.length) {
            this.nameIndexMap.put(this.namesOfColumns[i], i);
            ++i;
        }
        this.mappingPathElementTree = this.relationInfo.getTableMappingPathElementTree(this.tableName);
        if (this.namesOfNestedColumns.length > 0) {
            this.spNestedQueryHelper = new SaxParserNestedQueryHelper(this, rinfo, xmlSource, tName);
        }
        if (this.relationInfo.getTableFilter(this.tableName) != null && !this.relationInfo.getTableFilter(this.tableName).isEmpty()) {
            this.isContainRowFilter = true;
            this.filledRows = new LinkedList();
        }
        this.sp = new SaxParser(xmlSource, this, rinfo.containsNamespace());
        this.spThread = new Thread(this.sp);
        this.spThread.start();
    }

    @Override
    public void manipulateData(XMLPath path, String value) {
        int i = 0;
        while (i < this.processingRows.size()) {
            Row row = (Row)this.processingRows.get(i);
            this.fillNotNestColumn(row, path, value);
            ++i;
        }
    }

    private void fillNotNestColumn(Row row, XMLPath column, String value) {
        if (this.mappingPathElementTree != null) {
            int[] indexes = this.mappingPathElementTree.getMatchedButNotNestedColumnIndexs(column, row.path);
            int i = 0;
            while (i < indexes.length) {
                int index = indexes[i];
                if (this.namesOfColumns[index].startsWith("-$TEMP_XML_COLUMN$-")) {
                    row.values[index] = value;
                } else if (this.namesOfColumns[index].startsWith("-$TEMP_XML_COLUMN_ROOT$-")) {
                    if (row.values[index] == null) {
                        row.values[index] = value;
                    }
                } else if (row.values[index] == null && this.isColumnValid(this.namesOfColumns[index], row)) {
                    row.values[index] = value;
                }
                ++i;
            }
        }
    }

    private boolean isColumnValid(String columnName, Row row) {
        HashMap filters = this.relationInfo.getTableColumnFilter(this.tableName, columnName);
        if (filters == null) {
            return true;
        }
        for (Object filterColumnName : filters.keySet()) {
            Object value = filters.get(filterColumnName);
            if (SaxParserUtil.isTwoValueMatch(value, row.values[this.getColumnIndex(filterColumnName.toString())])) continue;
            return false;
        }
        return true;
    }

    private void fillNestColumns(Row row) {
        int i = 0;
        while (i < this.namesOfNestedColumns.length) {
            int j = this.getColumnIndex(this.namesOfNestedColumns[i]);
            if (j != -1) {
                HashMap filters = this.relationInfo.getTableColumnFilter(this.tableName, this.namesOfNestedColumns[i]);
                row.values[j] = this.spNestedQueryHelper.getNestedColumnValue(row.path, j, filters);
            }
            ++i;
        }
    }

    @Override
    public void startElement(XMLPath path) {
        if (this.mappingPathElementTree != null && this.mappingPathElementTree.matchesTablePath(path)) {
            Row newRow = new Row(path);
            this.processingRows.add(newRow);
            this.filledRows.add(newRow);
        }
    }

    @Override
    public void endElement(XMLPath path) {
        if (this.processingRows.size() > 0 && ((Row)this.processingRows.get((int)(this.processingRows.size() - 1))).path.equals(path)) {
            Row row = (Row)this.processingRows.get(this.processingRows.size() - 1);
            this.fillNestColumns(row);
            row.isFilled = true;
            if (this.isRowValid(row)) {
                this.suspendIfNecessary();
            } else {
                this.filledRows.remove(row);
            }
            this.processingRows.remove(this.processingRows.size() - 1);
        }
    }

    private void suspendIfNecessary() {
        Iterator itr = this.filledRows.iterator();
        int count = 0;
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            if (!row.isFilled) {
                return;
            }
            ++count;
        }
        if (count >= 100) {
            this.suspendParsingThread();
        }
    }

    private void moveFilledToPrepared() {
        String[][] result = new String[this.filledRows.size()][];
        Iterator itr = this.filledRows.iterator();
        int index = 0;
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            result[index++] = row.values;
        }
        this.filledRows.clear();
        this.prv.refresh(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendParsingThread() {
        this.moveFilledToPrepared();
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.sp;
        synchronized (object) {
            try {
                this.sp.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isRowValid(Row row) {
        if (!this.isContainRowFilter) {
            return true;
        }
        for (String columnName : this.relationInfo.getTableFilter(this.tableName).keySet()) {
            if (!this.isCurrentColumnValueNotMatchFilterValue(columnName, row)) continue;
            return false;
        }
        return true;
    }

    private boolean isCurrentColumnValueNotMatchFilterValue(String columnName, Row row) {
        int index = this.getColumnIndex(columnName);
        return !SaxParserUtil.isTwoValueMatch(this.relationInfo.getTableFilter(this.tableName).get(columnName), row.values[index]);
    }

    public int getColumnIndex(String columnName) {
        Object index = this.nameIndexMap.get(columnName);
        if (index == null) {
            return -1;
        }
        return (Integer)index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws OdaException {
        while (this.prv.size() < 100 && this.spThread.isAlive()) {
            Object object;
            if (this.prv.size() == 0) {
                object = this.sp;
                synchronized (object) {
                    this.sp.notifyAll();
                }
            }
            try {
                object = this;
                synchronized (object) {
                    this.wait(1L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean hasNext = this.prv.next();
        if (!hasNext && this.prv.size() >= 100 && this.spThread.isAlive()) {
            this.prv.refresh(null);
            return this.next();
        }
        return hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        this.moveFilledToPrepared();
        SaxParserConsumer saxParserConsumer = this;
        synchronized (saxParserConsumer) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        while (this.spThread.isAlive()) {
            SaxParser saxParser = this.sp;
            synchronized (saxParser) {
                this.sp.notifyAll();
            }
            this.sp.stopParsing();
        }
    }

    private static class PreparedRowsValues {
        private String[][] values = new String[0][];
        private int index = -1;

        private PreparedRowsValues() {
        }

        public synchronized void refresh(String[][] values) {
            this.index = -1;
            this.values = values == null ? new String[][]{} : values;
        }

        public synchronized boolean next() {
            ++this.index;
            return this.index < this.values.length;
        }

        public synchronized String[] getCurrentRowValues() {
            if (this.index >= 0 && this.index < this.values.length) {
                return this.values[this.index];
            }
            return null;
        }

        public synchronized int size() {
            return this.values.length;
        }
    }

    private class Row {
        public XMLPath path;
        public String[] values;
        public boolean isFilled;

        public Row(XMLPath path) {
            this.path = path;
            this.values = new String[SaxParserConsumer.this.relationInfo.getTableRealColumnNames(SaxParserConsumer.this.tableName).length];
            Arrays.fill(this.values, null);
            this.isFilled = false;
        }
    }
}

