/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.qt.core.index.IQObject;

public class QObjectMembers<T extends IQObject.IMember>
implements IQObject.IMembers<T> {
    private final List<T> all;
    private final Collection<T> locals;
    private Collection<T> withoutOverrides;

    public static <T extends IQObject.IMember> QObjectMembers<T> create(Collection<T> locals, Collection<T> inherited) {
        ArrayList<T> all = new ArrayList<T>(locals.size() + inherited.size());
        all.addAll(locals);
        all.addAll(inherited);
        return new QObjectMembers(all, locals);
    }

    private QObjectMembers(List<T> all, Collection<T> locals) {
        this.all = Collections.unmodifiableList(all);
        this.locals = Collections.unmodifiableCollection(locals);
    }

    @Override
    public Collection<T> all() {
        return this.all;
    }

    @Override
    public Collection<T> locals() {
        return this.locals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> withoutOverrides() {
        if (this.withoutOverrides == null) {
            List<T> list = this.all;
            synchronized (list) {
                if (this.withoutOverrides == null) {
                    ArrayList<IQObject.IMember> filtered = new ArrayList<IQObject.IMember>(this.all.size());
                    for (IQObject.IMember member : this.all) {
                        boolean isOverridden = false;
                        Iterator i = filtered.iterator();
                        while (!isOverridden && i.hasNext()) {
                            isOverridden = member.isOverride((IQObject.IMember)i.next());
                        }
                        if (isOverridden) continue;
                        filtered.add(member);
                    }
                    this.withoutOverrides = Collections.unmodifiableCollection(filtered);
                }
            }
        }
        return this.withoutOverrides;
    }
}

