/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.EnumSet;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class DeclaratorWriter
extends NodeWriter {
    private static final String AMPERSAND_AMPERSAND = "&&";
    private static final String PURE_VIRTUAL = " = 0";
    private static final String ARROW_OPERATOR = "->";

    public DeclaratorWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeDeclarator(IASTDeclarator declarator) {
        if (declarator instanceof IASTStandardFunctionDeclarator) {
            this.writeFunctionDeclarator((IASTStandardFunctionDeclarator)declarator);
        } else if (declarator instanceof IASTArrayDeclarator) {
            this.writeArrayDeclarator((IASTArrayDeclarator)declarator);
        } else if (declarator instanceof IASTFieldDeclarator) {
            this.writeFieldDeclarator((IASTFieldDeclarator)declarator);
        } else if (declarator instanceof ICASTKnRFunctionDeclarator) {
            this.writeCKnRFunctionDeclarator((ICASTKnRFunctionDeclarator)declarator);
        } else {
            this.writeDefaultDeclarator(declarator);
        }
        this.visitor.setSpaceNeededBeforeName(false);
        this.writeTrailingComments(declarator, false);
    }

    protected void writeDefaultDeclarator(IASTDeclarator declarator) {
        IASTPointerOperator[] pointOps = declarator.getPointerOperators();
        this.writePointerOperators(declarator, pointOps);
        this.writeParameterPack(declarator);
        IASTName name = declarator.getName();
        name.accept(this.visitor);
        this.writeNestedDeclarator(declarator);
        this.writeAttributes(declarator, EnumSet.of(NodeWriter.SpaceLocation.BEFORE));
        IASTInitializer init = this.getInitializer(declarator);
        if (init != null) {
            init.accept(this.visitor);
        }
    }

    protected void writePointerOperators(IASTDeclarator declarator, IASTPointerOperator[] pointOps) {
        IASTPointerOperator[] iASTPointerOperatorArray = pointOps;
        int n = pointOps.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator operator = iASTPointerOperatorArray[n2];
            this.writeGCCAttributes(operator, EnumSet.noneOf(NodeWriter.SpaceLocation.class));
            this.writePointerOperator(operator);
            this.writeCPPAttributes(operator, EnumSet.noneOf(NodeWriter.SpaceLocation.class));
            ++n2;
        }
    }

    private void writeParameterPack(IASTDeclarator declarator) {
        if (declarator instanceof ICPPASTDeclarator && ((ICPPASTDeclarator)declarator).declaresParameterPack()) {
            this.scribe.print("...");
        }
    }

    private void writeFunctionDeclarator(IASTStandardFunctionDeclarator funcDec) {
        IASTPointerOperator[] pointOps = funcDec.getPointerOperators();
        this.writePointerOperators(funcDec, pointOps);
        if (funcDec.getName() != null) {
            funcDec.getName().accept(this.visitor);
        }
        this.writeNestedDeclarator(funcDec);
        this.writeParameters(funcDec);
        this.writeInitializer(funcDec);
        if (funcDec instanceof ICPPASTFunctionDeclarator) {
            this.writeCppFunctionDeclarator((ICPPASTFunctionDeclarator)funcDec);
        }
    }

    private void writeInitializer(IASTStandardFunctionDeclarator funcDec) {
        IASTInitializer init = this.getInitializer(funcDec);
        if (init != null) {
            init.accept(this.visitor);
        }
    }

    private void writeParameters(IASTStandardFunctionDeclarator funcDec) {
        IASTParameterDeclaration[] paraDecls = funcDec.getParameters();
        this.scribe.print('(');
        this.writeParameterDeclarations(funcDec, paraDecls);
        this.scribe.print(')');
    }

    private void writeNestedDeclarator(IASTDeclarator funcDec) {
        IASTDeclarator nestedDeclarator = funcDec.getNestedDeclarator();
        if (nestedDeclarator != null) {
            if (this.visitor.isSpaceNeededBeforeName()) {
                this.scribe.printSpace();
                this.visitor.setSpaceNeededBeforeName(false);
            }
            this.scribe.print('(');
            nestedDeclarator.accept(this.visitor);
            this.scribe.print(')');
        }
    }

    private void writeCppFunctionDeclarator(ICPPASTFunctionDeclarator funcDec) {
        if (funcDec.isConst()) {
            this.scribe.printSpace();
            this.scribe.print("const");
        }
        if (funcDec.isVolatile()) {
            this.scribe.printSpace();
            this.scribe.print("volatile");
        }
        ICPPASTFunctionDeclarator.RefQualifier refQualifier = funcDec.getRefQualifier();
        this.writeRefQualifier(refQualifier);
        if (funcDec.isMutable()) {
            this.scribe.printSpace();
            this.scribe.print("mutable");
        }
        this.writeExceptionSpecification(funcDec, funcDec.getExceptionSpecification(), funcDec.getNoexceptExpression());
        this.writeAttributes(funcDec, EnumSet.of(NodeWriter.SpaceLocation.BEFORE));
        if (funcDec.getTrailingReturnType() != null) {
            this.scribe.printSpace();
            this.scribe.print(ARROW_OPERATOR);
            this.scribe.printSpace();
            funcDec.getTrailingReturnType().accept(this.visitor);
        }
        this.writeVirtualSpecifiers(funcDec);
        if (funcDec.isPureVirtual()) {
            this.scribe.print(PURE_VIRTUAL);
        }
    }

    public void writeVirtualSpecifiers(ICPPASTFunctionDeclarator funcDec) {
        ICPPASTVirtSpecifier[] iCPPASTVirtSpecifierArray = funcDec.getVirtSpecifiers();
        int n = iCPPASTVirtSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTVirtSpecifier virtSpecifier = iCPPASTVirtSpecifierArray[n2];
            this.scribe.printSpace();
            ICPPASTVirtSpecifier.SpecifierKind specifierKind = virtSpecifier.getKind();
            if (specifierKind == ICPPASTVirtSpecifier.SpecifierKind.Override) {
                this.scribe.print(Keywords.cOVERRIDE);
            }
            if (specifierKind == ICPPASTVirtSpecifier.SpecifierKind.Final) {
                this.scribe.print(Keywords.cFINAL);
            }
            ++n2;
        }
    }

    protected void writeExceptionSpecification(ICPPASTFunctionDeclarator funcDec, IASTTypeId[] exceptions, ICPPASTExpression noexceptExpression) {
        if (exceptions != ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION) {
            this.scribe.printSpace();
            this.scribe.printStringSpace("throw");
            this.scribe.print('(');
            this.writeNodeList(exceptions);
            this.scribe.print(')');
        }
        if (noexceptExpression != null) {
            this.scribe.printSpace();
            this.scribe.print("noexcept");
            if (noexceptExpression != ICPPASTFunctionDeclarator.NOEXCEPT_DEFAULT) {
                this.scribe.printSpace();
                this.scribe.print('(');
                noexceptExpression.accept(this.visitor);
                this.scribe.print(')');
            }
        }
    }

    protected void writeParameterDeclarations(IASTStandardFunctionDeclarator funcDec, IASTParameterDeclaration[] paramDecls) {
        this.writeNodeList(paramDecls);
        if (funcDec.takesVarArgs()) {
            if (paramDecls.length > 0) {
                this.scribe.print(", ");
            }
            this.scribe.print("...");
        }
    }

    private void writePointer(IASTPointer operator) {
        if (operator instanceof ICPPASTPointerToMember) {
            ICPPASTPointerToMember pointerToMemberOp = (ICPPASTPointerToMember)operator;
            if (pointerToMemberOp.getName() != null) {
                pointerToMemberOp.getName().accept(this.visitor);
                this.scribe.print('*');
            }
        } else {
            this.scribe.print('*');
        }
        if (operator.isConst()) {
            this.scribe.printStringSpace("const");
        }
        if (operator.isVolatile()) {
            this.scribe.printStringSpace("volatile");
        }
        if (operator.isRestrict()) {
            this.scribe.printStringSpace("restrict");
        }
    }

    public void writePointerOperator(IASTPointerOperator operator) {
        if (operator instanceof IASTPointer) {
            IASTPointer pointOp = (IASTPointer)operator;
            this.writePointer(pointOp);
        } else if (operator instanceof ICPPASTReferenceOperator) {
            if (((ICPPASTReferenceOperator)operator).isRValueReference()) {
                this.scribe.print(AMPERSAND_AMPERSAND);
            } else {
                this.scribe.print('&');
            }
        }
    }

    private void writeArrayDeclarator(IASTArrayDeclarator arrDecl) {
        IASTPointerOperator[] pointOps = arrDecl.getPointerOperators();
        this.writePointerOperators(arrDecl, pointOps);
        IASTName name = arrDecl.getName();
        name.accept(this.visitor);
        this.writeNestedDeclarator(arrDecl);
        IASTArrayModifier[] arrMods = arrDecl.getArrayModifiers();
        this.writeArrayModifiers(arrDecl, arrMods);
        IASTInitializer initializer = this.getInitializer(arrDecl);
        if (initializer != null) {
            initializer.accept(this.visitor);
        }
    }

    protected IASTInitializer getInitializer(IASTDeclarator decl) {
        return decl.getInitializer();
    }

    protected void writeArrayModifiers(IASTArrayDeclarator arrDecl, IASTArrayModifier[] arrMods) {
        IASTArrayModifier[] iASTArrayModifierArray = arrMods;
        int n = arrMods.length;
        int n2 = 0;
        while (n2 < n) {
            IASTArrayModifier modifier = iASTArrayModifierArray[n2];
            this.writeArrayModifier(modifier);
            ++n2;
        }
    }

    protected void writeArrayModifier(IASTArrayModifier modifier) {
        this.scribe.print('[');
        IASTExpression ex = modifier.getConstantExpression();
        if (ex != null) {
            ex.accept(this.visitor);
        }
        this.scribe.print(']');
        this.writeAttributes(modifier, EnumSet.noneOf(NodeWriter.SpaceLocation.class));
    }

    private void writeFieldDeclarator(IASTFieldDeclarator fieldDecl) {
        IASTPointerOperator[] pointOps = fieldDecl.getPointerOperators();
        this.writePointerOperators(fieldDecl, pointOps);
        fieldDecl.getName().accept(this.visitor);
        this.scribe.printSpace();
        this.scribe.print(':');
        this.scribe.printSpace();
        fieldDecl.getBitFieldSize().accept(this.visitor);
        IASTInitializer initializer = this.getInitializer(fieldDecl);
        if (initializer != null) {
            initializer.accept(this.visitor);
        }
    }

    private void writeCKnRFunctionDeclarator(ICASTKnRFunctionDeclarator knrFunct) {
        knrFunct.getName().accept(this.visitor);
        this.scribe.print('(');
        this.writeKnRParameterNames(knrFunct, knrFunct.getParameterNames());
        this.scribe.print(')');
        this.scribe.newLine();
        this.writeKnRParameterDeclarations(knrFunct, knrFunct.getParameterDeclarations());
    }

    protected void writeKnRParameterDeclarations(ICASTKnRFunctionDeclarator knrFunct, IASTDeclaration[] knrDeclarations) {
        int i = 0;
        while (i < knrDeclarations.length) {
            this.scribe.noNewLines();
            knrDeclarations[i].accept(this.visitor);
            this.scribe.newLines();
            if (i + 1 < knrDeclarations.length) {
                this.scribe.newLine();
            }
            ++i;
        }
    }

    protected void writeKnRParameterNames(ICASTKnRFunctionDeclarator knrFunct, IASTName[] parameterNames) {
        this.writeNodeList(parameterNames);
    }
}

