/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.core.runtime.CoreException;

public class CPPBasicType
implements ICPPBasicType,
ISerializableType {
    public static final CPPBasicType BOOLEAN = new CPPBasicType(IBasicType.Kind.eBoolean, 0, null);
    public static final CPPBasicType NULL_PTR = new CPPBasicType(IBasicType.Kind.eNullPtr, 0, null);
    public static final CPPBasicType UNSPECIFIED_TYPE = new CPPBasicType(IBasicType.Kind.eUnspecified, 0);
    public static final CPPBasicType SHORT = new CPPBasicType(IBasicType.Kind.eInt, 2);
    public static final CPPBasicType INT = new CPPBasicType(IBasicType.Kind.eInt, 0);
    public static final CPPBasicType LONG = new CPPBasicType(IBasicType.Kind.eInt, 1);
    public static final CPPBasicType LONG_LONG = new CPPBasicType(IBasicType.Kind.eInt, 64);
    public static final CPPBasicType INT128 = new CPPBasicType(IBasicType.Kind.eInt128, 0);
    public static final CPPBasicType UNSIGNED_SHORT = new CPPBasicType(IBasicType.Kind.eInt, 10);
    public static final CPPBasicType UNSIGNED_INT = new CPPBasicType(IBasicType.Kind.eInt, 8);
    public static final CPPBasicType UNSIGNED_LONG = new CPPBasicType(IBasicType.Kind.eInt, 9);
    public static final CPPBasicType UNSIGNED_LONG_LONG = new CPPBasicType(IBasicType.Kind.eInt, 72);
    public static final CPPBasicType UNSIGNED_INT128 = new CPPBasicType(IBasicType.Kind.eInt128, 8);
    public static final CPPBasicType CHAR = new CPPBasicType(IBasicType.Kind.eChar, 0);
    public static final CPPBasicType VOID = new CPPBasicType(IBasicType.Kind.eVoid, 0);
    public static final int FROM_LITERAL = 0x40000000;
    public static final int FROM_STRING_LITERAL = Integer.MIN_VALUE;
    private static final short TYPE_BUFFER_KIND_OFFSET = 32;
    private static final short TYPE_BUFFER_FROM_LITERAL_FLAG = 2048;
    private static final short TYPE_BUFFER_FIRST_FLAG_AFTER_KIND = 2048;
    private static final int MAX_KIND_INT_VALUE = 63;
    private final IBasicType.Kind fKind;
    private int fModifiers;
    private Long fAssociatedValue;
    private ICPPFunction fPseudoDestructor;

    public CPPBasicType(IBasicType.Kind kind, int qualifiers, IASTExpression expression) {
        this.fKind = kind == IBasicType.Kind.eUnspecified ? ((qualifiers & 0x30) != 0 ? IBasicType.Kind.eFloat : ((qualifiers & 0x4F) != 0 ? IBasicType.Kind.eInt : IBasicType.Kind.eUnspecified)) : kind;
        if (expression instanceof IASTLiteralExpression) {
            qualifiers |= 0x40000000;
            if (((IASTLiteralExpression)expression).getKind() == 3) {
                qualifiers |= Integer.MIN_VALUE;
            }
        }
        this.fModifiers = qualifiers;
        if (expression instanceof ICPPASTInitializerClause) {
            Number num = ValueFactory.create(expression).numberValue();
            this.fAssociatedValue = num != null ? Long.valueOf(num.longValue()) : null;
        }
    }

    public CPPBasicType(IBasicType.Kind kind, int qualifiers) {
        this(kind, qualifiers, null);
    }

    public CPPBasicType(ICPPASTSimpleDeclSpecifier sds) {
        this(CPPBasicType.getKind(sds), CPPBasicType.getModifiers(sds), null);
    }

    private static int getModifiers(ICPPASTSimpleDeclSpecifier sds) {
        return (sds.isLong() ? 1 : 0) | (sds.isShort() ? 2 : 0) | (sds.isSigned() ? 4 : 0) | (sds.isUnsigned() ? 8 : 0) | (sds.isLongLong() ? 64 : 0) | (sds.isComplex() ? 16 : 0) | (sds.isImaginary() ? 32 : 0);
    }

    private static IBasicType.Kind getKind(ICPPASTSimpleDeclSpecifier sds) {
        return CPPBasicType.getKind(sds.getType());
    }

    static IBasicType.Kind getKind(int simpleDeclSpecType) {
        switch (simpleDeclSpecType) {
            case 6: {
                return IBasicType.Kind.eBoolean;
            }
            case 2: {
                return IBasicType.Kind.eChar;
            }
            case 7: {
                return IBasicType.Kind.eWChar;
            }
            case 11: {
                return IBasicType.Kind.eChar16;
            }
            case 12: {
                return IBasicType.Kind.eChar32;
            }
            case 5: {
                return IBasicType.Kind.eDouble;
            }
            case 4: {
                return IBasicType.Kind.eFloat;
            }
            case 14: {
                return IBasicType.Kind.eFloat128;
            }
            case 15: {
                return IBasicType.Kind.eDecimal32;
            }
            case 16: {
                return IBasicType.Kind.eDecimal64;
            }
            case 17: {
                return IBasicType.Kind.eDecimal128;
            }
            case 3: {
                return IBasicType.Kind.eInt;
            }
            case 13: {
                return IBasicType.Kind.eInt128;
            }
            case 1: {
                return IBasicType.Kind.eVoid;
            }
        }
        return IBasicType.Kind.eUnspecified;
    }

    @Override
    public boolean isSameType(IType object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ITypedef) {
            return object.isSameType(this);
        }
        if (!(object instanceof ICPPBasicType)) {
            return false;
        }
        ICPPBasicType other = (ICPPBasicType)object;
        if (this.fKind != other.getKind()) {
            return false;
        }
        int modifiers = this.getModifiers();
        int otherModifiers = other.getModifiers();
        if (this.fKind == IBasicType.Kind.eInt) {
            return (modifiers & 0xFFFFFFFB) == (otherModifiers & 0xFFFFFFFB);
        }
        return modifiers == otherModifiers;
    }

    @Override
    public IBasicType.Kind getKind() {
        return this.fKind;
    }

    @Override
    public boolean isSigned() {
        return (this.fModifiers & 4) != 0;
    }

    @Override
    public boolean isUnsigned() {
        return (this.fModifiers & 8) != 0;
    }

    @Override
    public boolean isShort() {
        return (this.fModifiers & 2) != 0;
    }

    @Override
    public boolean isLong() {
        return (this.fModifiers & 1) != 0;
    }

    @Override
    public boolean isLongLong() {
        return (this.fModifiers & 0x40) != 0;
    }

    @Override
    public boolean isComplex() {
        return (this.fModifiers & 0x10) != 0;
    }

    @Override
    public boolean isImaginary() {
        return (this.fModifiers & 0x20) != 0;
    }

    @Override
    public CPPBasicType clone() {
        return this.clone(-1);
    }

    public CPPBasicType clone(int flagsMask) {
        CPPBasicType t = null;
        try {
            t = (CPPBasicType)super.clone();
            t.fModifiers &= flagsMask;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    public final void setAssociatedNumericalValue(Long value) {
        this.fAssociatedValue = value;
    }

    public final Long getAssociatedNumericalValue() {
        return this.fAssociatedValue;
    }

    public final boolean isFromStringLiteral() {
        return (this.fModifiers & Integer.MIN_VALUE) != 0;
    }

    public final boolean isFromLiteral() {
        return (this.fModifiers & 0x40000000) != 0;
    }

    @Override
    public final int getModifiers() {
        return this.fModifiers & Integer.MAX_VALUE & 0xBFFFFFFF;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int kind = this.getKind().ordinal();
        if (kind > 63) {
            throw new CoreException(CCorePlugin.createStatus(MessageFormat.format("Cannot marshal a basic type, kind ''{0}'' would overflow following flags.", this.getKind().toString())));
        }
        int shiftedKind = kind * 32;
        int modifiers = this.getModifiers();
        short firstBytes = (short)(1 | shiftedKind);
        if (this.isFromLiteral()) {
            firstBytes = CPPBasicType.setFirstBytesFlag(firstBytes, (short)2048);
        }
        if (this.fAssociatedValue != null) {
            firstBytes = CPPBasicType.setFirstBytesFlag(firstBytes, (short)4096);
        }
        if (modifiers != 0) {
            firstBytes = CPPBasicType.setFirstBytesFlag(firstBytes, (short)8192);
        }
        buffer.putShort(firstBytes);
        if (modifiers != 0) {
            buffer.putByte((byte)modifiers);
        }
        if (this.fAssociatedValue != null) {
            buffer.putLong(this.getAssociatedNumericalValue());
        }
    }

    private static short setFirstBytesFlag(short firstBytes, short flag) throws CoreException {
        if (flag < 2048) {
            throw new CoreException(CCorePlugin.createStatus(MessageFormat.format("Cannot marshal a basic type, flag ''0x{0}'' overlaps ''kind'' bytes.", Integer.toHexString(flag))));
        }
        return (short)(firstBytes | flag);
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean haveModifiers = (firstBytes & 0x2000) != 0;
        boolean haveAssociatedNumericalValue = (firstBytes & 0x1000) != 0;
        int modifiers = 0;
        int kind = (firstBytes & 0x7FF) / 32;
        if (haveModifiers) {
            modifiers = buffer.getByte();
        }
        if ((firstBytes & 0x800) != 0) {
            modifiers |= 0x40000000;
        }
        CPPBasicType result = new CPPBasicType(IBasicType.Kind.values()[kind], modifiers);
        if (haveAssociatedNumericalValue) {
            result.setAssociatedNumericalValue(buffer.getLong());
        }
        return result;
    }

    @Override
    @Deprecated
    public int getQualifierBits() {
        return this.getModifiers();
    }

    @Override
    @Deprecated
    public int getType() {
        switch (this.fKind) {
            case eBoolean: {
                return 6;
            }
            case eChar: 
            case eChar16: 
            case eChar32: {
                return 2;
            }
            case eWChar: {
                return 7;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eInt: {
                return 3;
            }
            case eVoid: {
                return 1;
            }
            case eUnspecified: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    @Deprecated
    public IASTExpression getValue() {
        return null;
    }

    @Override
    public ICPPFunction getPseudoDestructor() {
        if (this.fPseudoDestructor == null) {
            char[] dtorName = ("~" + this.toString()).toCharArray();
            IScope globalScope = CPPSemantics.getCurrentLookupPoint().getTranslationUnit().getScope();
            this.fPseudoDestructor = new CPPImplicitFunction(dtorName, globalScope, CPPClassScope.DESTRUCTOR_FUNCTION_TYPE, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, true, false);
        }
        return this.fPseudoDestructor;
    }
}

