/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import java.util.List;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractProjectWizard;
import org.eclipse.buildship.ui.internal.wizard.project.GradleOptionsWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.GradleProjectWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.GradleWelcomeWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportWizardController;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectPreviewWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.internal.wizard.project.WelcomePageContent;
import org.eclipse.buildship.ui.internal.wizard.project.WelcomePageContentFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public final class ProjectImportWizard
extends AbstractProjectWizard
implements IImportWizard {
    private static final String PROJECT_IMPORT_DIALOG_SETTINGS = "org.eclipse.buildship.ui.wizard.project.import";
    private static final String PREF_SHOW_WELCOME_PAGE = "org.eclipse.buildship.ui.wizard.project.import.showWelcomePage";
    private final GradleWelcomeWizardPage welcomeWizardPage;
    private final GradleProjectWizardPage gradleProjectPage;
    private final GradleOptionsWizardPage gradleOptionsPage;
    private final ProjectPreviewWizardPage projectPreviewPage;
    private final ProjectImportWizardController controller;

    public ProjectImportWizard() {
        this(ProjectImportWizard.getOrCreateDialogSection(UiPlugin.getInstance().getDialogSettings()));
    }

    public ProjectImportWizard(IDialogSettings dialogSettings) {
        super(PREF_SHOW_WELCOME_PAGE);
        this.setDialogSettings(dialogSettings);
        this.controller = new ProjectImportWizardController((IWizard)this);
        ProjectImportConfiguration configuration = this.controller.getConfiguration();
        WelcomePageContent welcomePageContent = WelcomePageContentFactory.createImportWizardWelcomePageContent();
        this.welcomeWizardPage = new GradleWelcomeWizardPage(configuration, welcomePageContent);
        this.gradleProjectPage = new GradleProjectWizardPage(configuration);
        this.gradleOptionsPage = new GradleOptionsWizardPage(configuration);
        this.projectPreviewPage = new ProjectPreviewWizardPage(this.controller.getConfiguration());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List<String> workingSetNames = WorkingSetUtils.getSelectedWorkingSetNames(selection);
        if (!workingSetNames.isEmpty()) {
            this.controller.getConfiguration().setApplyWorkingSets(true);
            this.controller.getConfiguration().setWorkingSets(workingSetNames);
        }
    }

    public String getWindowTitle() {
        return ProjectWizardMessages.Title_GradleProjectWizardPage;
    }

    public void addPages() {
        if (this.isShowWelcomePage()) {
            this.addPage((IWizardPage)this.welcomeWizardPage);
        }
        this.addPage((IWizardPage)this.gradleProjectPage);
        this.addPage((IWizardPage)this.gradleOptionsPage);
        this.addPage((IWizardPage)this.projectPreviewPage);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
    }

    public boolean performFinish() {
        return this.controller.performImportProject(this.getContainer(), NewProjectHandler.IMPORT_AND_MERGE);
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.buildship.ui.projectimport";
    }

    private static IDialogSettings getOrCreateDialogSection(IDialogSettings dialogSettings) {
        IDialogSettings section = dialogSettings.getSection(PROJECT_IMPORT_DIALOG_SETTINGS);
        if (section == null) {
            section = dialogSettings.addNewSection(PROJECT_IMPORT_DIALOG_SETTINGS);
        }
        return section;
    }
}

