/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.store.fs.FileUtils;

public class FileChannelInputStream
extends InputStream {
    private FileChannel channel;
    private byte[] buffer = new byte[]{0};

    public FileChannelInputStream(FileChannel fileChannel) {
        this.channel = fileChannel;
    }

    public int read() throws IOException {
        if (this.channel.position() >= this.channel.size()) {
            return -1;
        }
        FileUtils.readFully(this.channel, ByteBuffer.wrap(this.buffer));
        return this.buffer[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.channel.position() + (long)n2 < this.channel.size()) {
            FileUtils.readFully(this.channel, ByteBuffer.wrap(byArray, n, n2));
            return n2;
        }
        return super.read(byArray, n, n2);
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

